/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.bounded;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalBoundedCountHistogramFacet
extends InternalHistogramFacet {
    private static final String STREAM_TYPE = "cBdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalBoundedCountHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    HistogramFacet.ComparatorType comparatorType;
    boolean cachedCounts;
    int[] counts;
    int size;
    long interval;
    long offset;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalBoundedCountHistogramFacet() {
    }

    public InternalBoundedCountHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, long interval, long offset, int size, int[] counts, boolean cachedCounts) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.interval = interval;
        this.offset = offset;
        this.counts = counts;
        this.size = size;
        this.cachedCounts = cachedCounts;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<CountEntry> entries() {
        return Arrays.asList(this.computeEntries());
    }

    public List<CountEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    private CountEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountEntry[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.entries[i] = new CountEntry((long)i * this.interval + this.offset, this.counts[i]);
        }
        this.releaseCache();
        return this.entries;
    }

    void releaseCache() {
        if (this.cachedCounts) {
            this.cachedCounts = false;
            CacheRecycler.pushIntArray(this.counts);
            this.counts = null;
        }
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            InternalBoundedCountHistogramFacet firstHistoFacet = (InternalBoundedCountHistogramFacet)facets.get(0);
            if (this.comparatorType != HistogramFacet.ComparatorType.KEY) {
                Arrays.sort(firstHistoFacet.entries, this.comparatorType.comparator());
            }
            return facets.get(0);
        }
        InternalBoundedCountHistogramFacet firstHistoFacet = (InternalBoundedCountHistogramFacet)facets.get(0);
        for (int i = 1; i < facets.size(); ++i) {
            InternalBoundedCountHistogramFacet histoFacet = (InternalBoundedCountHistogramFacet)facets.get(i);
            for (int j = 0; j < firstHistoFacet.size; ++j) {
                int n = j;
                firstHistoFacet.counts[n] = firstHistoFacet.counts[n] + histoFacet.counts[j];
            }
            histoFacet.releaseCache();
        }
        if (this.comparatorType != HistogramFacet.ComparatorType.KEY) {
            Arrays.sort(firstHistoFacet.entries, this.comparatorType.comparator());
        }
        return firstHistoFacet;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (int i = 0; i < this.size; ++i) {
            builder.startObject();
            builder.field(Fields.KEY, (long)i * this.interval + this.offset);
            builder.field(Fields.COUNT, this.counts[i]);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        this.releaseCache();
        return builder;
    }

    public static InternalBoundedCountHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalBoundedCountHistogramFacet facet = new InternalBoundedCountHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        this.offset = in.readLong();
        this.interval = in.readVLong();
        this.size = in.readVInt();
        this.counts = CacheRecycler.popIntArray(this.size);
        this.cachedCounts = true;
        for (int i = 0; i < this.size; ++i) {
            this.counts[i] = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeLong(this.offset);
        out.writeVLong(this.interval);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.counts[i]);
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements HistogramFacet.Entry {
        private final long key;
        private final long count;

        public CountEntry(long key, long count) {
            this.key = key;
            this.count = count;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long getKey() {
            return this.key();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return Double.NaN;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public long totalCount() {
            return 0L;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double mean() {
            return Double.NaN;
        }

        @Override
        public double getMean() {
            return this.mean();
        }

        @Override
        public double min() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double max() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

