/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;
import org.elasticsearch.transport.TransportService;

@MBean(objectName="service=transport", description="Transport")
public class TransportServiceManagement {
    private final TransportService transportService;

    @Inject
    public TransportServiceManagement(TransportService transportService) {
        this.transportService = transportService;
    }

    @ManagedAttribute(description="Transport address published to other nodes")
    public String getPublishAddress() {
        return this.transportService.boundAddress().publishAddress().toString();
    }

    @ManagedAttribute(description="Transport address bounded on")
    public String getBoundAddress() {
        return this.transportService.boundAddress().boundAddress().toString();
    }

    @ManagedAttribute(description="Total number of transport requests sent")
    public long getTotalNumberOfRequests() {
        return this.transportService.requestIds.get();
    }
}

