/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.metrics.mvel;

import io.fabric8.insight.metrics.model.Metrics;
import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.mvel.Renderer;
import io.fabric8.insight.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsStorageServiceImpl
implements MetricsStorageService {
    private static final transient Logger LOG = LoggerFactory.getLogger(MetricsStorageServiceImpl.class);
    private StorageService storageService;
    private Renderer renderer = new Renderer();

    public MetricsStorageServiceImpl() {
    }

    public MetricsStorageServiceImpl(StorageService storageService) {
        this.storageService = storageService;
    }

    public void store(String type, long timestamp, QueryResult qrs) {
        String output = null;
        try {
            output = this.renderer.render(qrs);
        }
        catch (Exception e) {
            LOG.warn("Failed to render " + qrs + " to JSON: " + e, (Throwable)e);
        }
        if (output == null || output.trim().isEmpty()) {
            return;
        }
        String name = Metrics.metricId((String)type, (QueryResult)qrs);
        this.storageService.store(name, timestamp, output);
    }

    public StorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(StorageService storageService) {
        this.storageService = storageService;
    }
}

