/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.metrics.mvel;

import io.fabric8.common.util.IOHelpers;
import io.fabric8.insight.metrics.model.MetricsJSON;
import io.fabric8.insight.metrics.model.Query;
import io.fabric8.insight.metrics.model.QueryResult;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class Renderer {
    private Map<Query, String> sources = new ConcurrentHashMap<Query, String>();
    private Map<String, CompiledTemplate> templates = new ConcurrentHashMap<String, CompiledTemplate>();
    private ParserContext context = new ParserContext();

    public Renderer() {
        try {
            this.context.addImport("toJson", MetricsJSON.class.getMethod("toJson", Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find method toJson", e);
        }
    }

    public String render(QueryResult qrs) throws Exception {
        HashMap<String, QueryResult> vars = new HashMap<String, QueryResult>();
        vars.put("result", qrs);
        return TemplateRuntime.execute((CompiledTemplate)this.getTemplate(qrs.getQuery()), (Object)this.context, vars).toString();
    }

    private CompiledTemplate getTemplate(Query set) throws IOException {
        String source = this.getTemplateSource(set);
        CompiledTemplate template = this.templates.get(source);
        if (template == null) {
            template = TemplateCompiler.compileTemplate((String)source, (ParserContext)this.context);
            this.templates.put(source, template);
        }
        return template;
    }

    private String getTemplateSource(Query set) throws IOException {
        String source = this.sources.get(set);
        if (source == null) {
            if (set.getTemplate() != null) {
                source = IOHelpers.loadFully((URL)new URL(set.getTemplate()));
            }
            if (source == null) {
                URL url = this.getClass().getResource("/io/fabric8/insight/metrics/" + set.getName() + ".mvel");
                if (url == null) {
                    url = this.getClass().getResource("/io/fabric8/insight/metrics/default.mvel");
                }
                if (url != null) {
                    source = IOHelpers.loadFully((URL)url);
                } else {
                    throw new IllegalStateException("Could not find default template");
                }
            }
            this.sources.put(set, source);
        }
        return source;
    }
}

