/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaas;

import io.fabric8.jaas.BasicEncryptionSupport;
import io.fabric8.jaas.GroupPrincipal;
import io.fabric8.zookeeper.curator.CuratorFrameworkLocator;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.jaas.boot.principal.RolePolicy;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperLoginModule.class);
    private Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;
    private String roleDiscriminator;
    private String rolePolicy;
    private Subject subject;
    private boolean debug = false;
    private Properties users = new Properties();
    private Properties containers = new Properties();
    private EncryptionSupport encryptionSupport;
    private String path;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.roleDiscriminator = (String)options.get("role.discriminator");
        this.rolePolicy = (String)options.get("role.policy");
        this.encryptionSupport = new BasicEncryptionSupport(options);
        this.debug = Boolean.parseBoolean((String)options.get("debug"));
        this.path = (String)options.get("path");
        if (this.path == null) {
            this.path = "/fabric/authentication/users";
        }
        try {
            CuratorFramework curator = CuratorFrameworkLocator.getCuratorFramework();
            if (curator != null) {
                this.users = ZooKeeperUtils.getProperties((CuratorFramework)curator, (String)this.path);
                this.containers = ZooKeeperUtils.getContainerTokens((CuratorFramework)curator);
            }
            if (this.debug) {
                LOG.debug("Initialize [" + this + "] - curator=" + curator + ",users=" + this.users);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed fetching authentication data.", (Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean result;
        String user;
        block18: {
            user = null;
            try {
                Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (IOException ioe) {
                    throw new LoginException(ioe.getMessage());
                }
                catch (UnsupportedCallbackException uce) {
                    throw new LoginException(uce.getMessage() + " not available to obtain information from user");
                }
                user = ((NameCallback)callbacks[0]).getName();
                if (user == null) {
                    throw new FailedLoginException("user name is null");
                }
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmpPassword == null) {
                    tmpPassword = new char[]{};
                }
                if (this.debug) {
                    LOG.debug("Login [" + this + "] - user=" + user + ",users=" + this.users);
                }
                if (ZooKeeperUtils.isContainerLogin((String)user)) {
                    String token = this.containers.getProperty(user);
                    if (token == null) {
                        throw new FailedLoginException("Container doesn't exist");
                    }
                    if (!new String(tmpPassword).equals(token)) {
                        throw new FailedLoginException("Tokens do not match");
                    }
                    this.principals = new HashSet<Principal>();
                    this.principals.add((Principal)new UserPrincipal(user));
                    this.principals.add((Principal)new RolePrincipal("container"));
                    this.principals.add((Principal)new RolePrincipal("admin"));
                    this.subject.getPrivateCredentials().add(new String(tmpPassword));
                    result = true;
                    break block18;
                }
                String userInfos = this.users.getProperty(user);
                if (userInfos == null) {
                    throw new FailedLoginException("User doesn't exist");
                }
                String[] infos = userInfos.split(",");
                String password = infos[0];
                if (!this.checkPassword(new String(tmpPassword), password)) {
                    throw new FailedLoginException("Password does not match");
                }
                this.principals = new HashSet<Principal>();
                this.principals.add((Principal)new UserPrincipal(user));
                for (int i = 1; i < infos.length; ++i) {
                    if (infos[i].trim().startsWith("_g_:")) {
                        this.principals.add(new GroupPrincipal(infos[i].trim().substring("_g_:".length())));
                        String groupInfo = (String)this.users.get(infos[i].trim());
                        if (groupInfo == null) continue;
                        String[] roles = groupInfo.split(",");
                        for (int j = 1; j < roles.length; ++j) {
                            this.principals.add((Principal)new RolePrincipal(roles[j].trim()));
                        }
                        continue;
                    }
                    this.principals.add((Principal)new RolePrincipal(infos[i].trim()));
                }
                this.subject.getPrivateCredentials().add(new String(tmpPassword));
                result = true;
            }
            catch (LoginException ex) {
                if (this.debug) {
                    LOG.debug("Login failed {}", user, (Object)ex);
                }
                throw ex;
            }
        }
        if (this.debug) {
            LOG.debug("Successfully logged in {}", (Object)user);
        }
        return result;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        RolePolicy policy = RolePolicy.getPolicy((String)this.rolePolicy);
        if (policy != null && this.roleDiscriminator != null) {
            policy.handleRoles(this.subject, this.principals, this.roleDiscriminator);
        } else {
            this.subject.getPrincipals().addAll(this.principals);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    public String getEncryptedPassword(String password) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return password;
        }
        boolean prefix = encryptionPrefix == null || password.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || password.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            return password;
        }
        String p = encryption.encryptPassword(password);
        if (encryptionPrefix != null) {
            p = encryptionPrefix + p;
        }
        if (encryptionSuffix != null) {
            p = p + encryptionSuffix;
        }
        return p;
    }

    public boolean checkPassword(String plain, String encrypted) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return plain.equals(encrypted);
        }
        boolean prefix = encryptionPrefix == null || encrypted.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || encrypted.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            encrypted = encrypted.substring(encryptionPrefix != null ? encryptionPrefix.length() : 0, encrypted.length() - (encryptionSuffix != null ? encryptionSuffix.length() : 0));
            return encryption.checkPassword(plain, encrypted);
        }
        return plain.equals(encrypted);
    }
}

