/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.url.internal;

import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.url.internal.AetherBasedResolver;
import io.fabric8.maven.url.internal.Connection;
import io.fabric8.maven.util.MavenConfigurationImpl;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractURLStreamHandlerService
implements BundleActivator,
ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final String PID = "io.fabric8.maven";
    private static final String PROTOCOL = "mvn";
    private BundleContext m_bundleContext;
    private volatile MavenResolver m_resolver;
    private ServiceRegistration m_handlerReg;
    private ServiceRegistration m_managedServiceReg;
    private final AtomicReference<ServiceRegistration> m_resolverReg = new AtomicReference();

    public void start(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
        this.updated(null);
        this.registerManagedService();
        this.registerHandler();
    }

    public void stop(BundleContext bundleContext) {
        ServiceRegistration registration;
        if (this.m_handlerReg != null) {
            this.m_handlerReg.unregister();
            this.m_handlerReg = null;
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
            this.m_managedServiceReg = null;
        }
        if ((registration = (ServiceRegistration)this.m_resolverReg.getAndSet(null)) != null) {
            registration.unregister();
        }
        this.m_bundleContext = null;
        LOG.debug("Handler for protocols mvn stopped");
    }

    private void registerHandler() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", PROTOCOL);
        this.m_handlerReg = this.m_bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)this, props);
    }

    private void registerManagedService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", PID);
        this.m_managedServiceReg = this.m_bundleContext.registerService(ManagedService.class.getName(), (Object)this, props);
    }

    public void updated(Dictionary<String, ?> config) {
        Object propertyResolver = config == null ? new PropertyResolver(){

            public String get(String propertyName) {
                return Activator.this.m_bundleContext.getProperty(propertyName);
            }
        } : new DictionaryPropertyResolver(config);
        MavenConfigurationImpl mavenConfig = new MavenConfigurationImpl((PropertyResolver)propertyResolver, PID);
        AetherBasedResolver resolver = new AetherBasedResolver(mavenConfig);
        this.m_resolver = resolver;
        ServiceRegistration registration = this.m_bundleContext.registerService(MavenResolver.class.getName(), (Object)resolver, null);
        if ((registration = this.m_resolverReg.getAndSet(registration)) != null) {
            registration.unregister();
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new Connection(url, this.m_resolver);
    }
}

