/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl;

import javax.xml.stream.XMLStreamException;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.impl.XMLSecurityStreamReader;

public class WSSecurityStreamReader
extends XMLSecurityStreamReader {
    private final boolean initiator;

    public WSSecurityStreamReader(InputProcessorChain inputProcessorChain, XMLSecurityProperties securityProperties, boolean initiator) {
        super(inputProcessorChain, securityProperties);
        this.initiator = initiator;
    }

    public int next() throws XMLStreamException {
        try {
            return super.next();
        }
        catch (XMLStreamException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WSSecurityException) {
                if (this.initiator || cause.getCause() instanceof WSSPolicyException) {
                    throw e;
                }
                String error = ((WSSecurityException)cause).getSafeExceptionMessage();
                throw new XMLStreamException(new WSSecurityException(((WSSecurityException)cause).getErrorCode(), new Exception(error)));
            }
            if (cause instanceof XMLSecurityException) {
                throw new XMLStreamException(new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)((Object)((XMLSecurityException)cause))));
            }
            throw e;
        }
    }
}

