/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.log.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogRequest {
    private long from;
    private long size;
    private List<Map<String, String>> sort;
    private Map query;

    public static LogRequest newInstance(Long maxLogSeq) {
        ArrayList<Map<String, String>> s = new ArrayList<Map<String, String>>();
        s.add(LogRequest.keyValueMap("timestamp", "desc"));
        s.add(LogRequest.keyValueMap("seq", "desc"));
        HashMap q = new HashMap();
        HashMap constant_score = new HashMap();
        HashMap filter = new HashMap();
        q.put("constant_score", constant_score);
        constant_score.put("filter", filter);
        ArrayList<Map> listOfTerms = new ArrayList<Map>();
        listOfTerms.add(LogRequest.createSearchTerms("level", "error", "warn", "info"));
        if (maxLogSeq != null) {
            listOfTerms.add(LogRequest.createSearchRangeGt("seq", maxLogSeq));
        }
        filter.put("and", listOfTerms);
        return new LogRequest(0L, 50L, s, q);
    }

    private static Map<String, String> keyValueMap(String key, String value) {
        HashMap<String, String> answer = new HashMap<String, String>();
        answer.put(key, value);
        return answer;
    }

    protected static Map createSearchRangeGt(String name, Object value) {
        return LogRequest.createSearchRange(name, "gt", value);
    }

    protected static Map createSearchRange(String name, String compareOperation, Object value) {
        HashMap answer = new HashMap();
        HashMap range = new HashMap();
        HashMap<String, Object> compare = new HashMap<String, Object>();
        answer.put("range", range);
        range.put(compareOperation, compare);
        compare.put(name, value);
        return answer;
    }

    protected static Map createSearchTerm(String name, String value) {
        HashMap answer = new HashMap();
        HashMap<String, String> term = new HashMap<String, String>();
        answer.put("term", term);
        term.put(name, value);
        return answer;
    }

    protected static Map createSearchTerms(String name, String ... values) {
        HashMap answer = new HashMap();
        HashMap<String, ArrayList<String>> term = new HashMap<String, ArrayList<String>>();
        answer.put("terms", term);
        term.put(name, new ArrayList<String>(Arrays.asList(values)));
        return answer;
    }

    @JsonCreator
    public LogRequest(long from, long size, List<Map<String, String>> sort, Map query) {
        this.from = from;
        this.size = size;
        this.sort = sort;
        this.query = query;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<Map<String, String>> getSort() {
        return this.sort;
    }

    public void setSort(List<Map<String, String>> sort) {
        this.sort = sort;
    }

    public Map getQuery() {
        return this.query;
    }

    public void setQuery(Map query) {
        this.query = query;
    }
}

