/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.Deployment;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.ModuleReloader;

public class Redeployer {
    private static final Logger log = LoggerFactory.getLogger(Redeployer.class);
    private static final long CHECK_PERIOD = 240L;
    private static final long GRACE_PERIOD = 1000L;
    private final VertxInternal vertx;
    private final ModuleReloader reloader;
    private final Map<ModuleIdentifier, Set<Deployment>> deployments = new HashMap<ModuleIdentifier, Set<Deployment>>();
    private final Map<ModuleIdentifier, Set<File>> watchedDirs = new HashMap<ModuleIdentifier, Set<File>>();
    private final Map<File, Map<File, FileInfo>> directoryFiles = new HashMap<File, Map<File, FileInfo>>();
    private final Map<ModuleIdentifier, Long> changing = new HashMap<ModuleIdentifier, Long>();
    private long timerID;
    private boolean closed;
    private boolean scannerStarted;
    private Runnable checker = new Runnable(){

        @Override
        public void run() {
            Redeployer.this.checkForChanges();
        }
    };

    public boolean isEmpty() {
        return this.deployments.isEmpty() && this.watchedDirs.isEmpty() && this.directoryFiles.isEmpty();
    }

    public Redeployer(VertxInternal vertx, ModuleReloader reloader) {
        this.vertx = vertx;
        this.reloader = reloader;
    }

    private void setTimer() {
        this.timerID = this.vertx.setTimer(240L, new Handler<Long>(){

            @Override
            public void handle(Long id) {
                Redeployer.this.runInBackground(Redeployer.this.checker);
            }
        });
    }

    public synchronized void close() {
        this.vertx.cancelTimer(this.timerID);
        this.scannerStarted = false;
        this.closed = true;
    }

    public synchronized void moduleDeployed(Deployment deployment) {
        log.trace("Registering module: " + deployment.modID);
        Set<Deployment> deps = this.deployments.get(deployment.modID);
        if (deps == null) {
            HashSet<File> watched = new HashSet<File>();
            ArrayList totCP = new ArrayList();
            Collections.addAll(totCP, deployment.classpath);
            if (deployment.includedClasspath != null) {
                Collections.addAll(totCP, deployment.includedClasspath);
            }
            for (URL url : totCP) {
                File file;
                String sfile = url.getFile();
                if (sfile == null || !(file = new File(sfile)).isDirectory()) continue;
                this.addDirectory(watched, file);
            }
            this.watchedDirs.put(deployment.modID, watched);
            deps = new HashSet<Deployment>();
            this.deployments.put(deployment.modID, deps);
        }
        deps.add(deployment);
        if (!this.scannerStarted) {
            this.setTimer();
            this.scannerStarted = true;
        }
    }

    private void addDirectory(Set<File> dirs, File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalStateException("Not directory: " + directory);
        }
        dirs.add(directory);
        File[] children = directory.listFiles();
        HashMap<File, FileInfo> map = new HashMap<File, FileInfo>();
        for (File child : children) {
            map.put(child, new FileInfo(child.lastModified(), child.length()));
        }
        this.directoryFiles.put(directory, map);
        for (File child : children) {
            if (!child.isDirectory()) continue;
            this.addDirectory(dirs, child);
        }
    }

    public synchronized void moduleUndeployed(Deployment deployment) {
        Set<Deployment> deps;
        Set<File> watched = this.watchedDirs.remove(deployment.modID);
        if (watched != null) {
            for (File dir : watched) {
                this.directoryFiles.remove(dir);
            }
        }
        if ((deps = this.deployments.get(deployment.modID)) != null) {
            deps.remove(deployment);
            if (deps.isEmpty()) {
                this.deployments.remove(deployment.modID);
            }
        }
    }

    private synchronized void checkForChanges() {
        if (this.closed) {
            return;
        }
        HashSet<ModuleIdentifier> haveChanged = new HashSet<ModuleIdentifier>();
        for (Map.Entry<ModuleIdentifier, Set<File>> entry : this.watchedDirs.entrySet()) {
            ModuleIdentifier modID = entry.getKey();
            Set<File> dirs = entry.getValue();
            boolean changed = false;
            for (File dir : new HashSet<File>(dirs)) {
                File[] files = dir.exists() ? dir.listFiles() : new File[]{};
                HashMap<File, File> newFiles = new HashMap<File, File>();
                for (File file : files) {
                    newFiles.put(file, file);
                }
                Map<File, FileInfo> currentFileMap = this.directoryFiles.get(dir);
                for (Map.Entry<File, FileInfo> currentEntry : new HashMap<File, FileInfo>(currentFileMap).entrySet()) {
                    File currFile = currentEntry.getKey();
                    FileInfo currInfo = currentEntry.getValue();
                    File newFile = (File)newFiles.get(currFile);
                    if (newFile == null) {
                        currentFileMap.remove(currFile);
                        if (currentFileMap.isEmpty()) {
                            this.directoryFiles.remove(dir);
                            dirs.remove(dir);
                        }
                        changed = true;
                        continue;
                    }
                    if (newFile.lastModified() == currInfo.lastModified && newFile.length() == currInfo.length) continue;
                    currentFileMap.put(newFile, new FileInfo(newFile.lastModified(), newFile.length()));
                    changed = true;
                }
                for (File newFile : files) {
                    if (currentFileMap.containsKey(newFile)) continue;
                    currentFileMap.put(newFile, new FileInfo(newFile.lastModified(), newFile.length()));
                    if (newFile.isDirectory()) {
                        HashSet<File> dirsToAdd = new HashSet<File>();
                        this.addDirectory(dirsToAdd, newFile);
                        dirs.addAll(dirsToAdd);
                    }
                    changed = true;
                }
            }
            if (!changed) continue;
            haveChanged.add(modID);
        }
        long now = System.currentTimeMillis();
        for (ModuleIdentifier modID : haveChanged) {
            this.changing.put(modID, now);
        }
        HashSet<ModuleIdentifier> toReload = new HashSet<ModuleIdentifier>();
        HashSet<ModuleIdentifier> toNotReload = new HashSet<ModuleIdentifier>();
        for (Map.Entry<ModuleIdentifier, Long> changeEntry : new HashMap<ModuleIdentifier, Long>(this.changing).entrySet()) {
            ModuleIdentifier modID = changeEntry.getKey();
            if (now - changeEntry.getValue() >= 1000L) {
                toReload.add(modID);
                this.changing.remove(modID);
                continue;
            }
            toNotReload.add(modID);
        }
        toReload.removeAll(toNotReload);
        for (ModuleIdentifier modID : toReload) {
            log.info("Module " + modID + " has changed, reloading it.");
            Set<Deployment> deps = this.deployments.get(modID);
            this.reloader.reloadModules(deps);
        }
        this.setTimer();
    }

    private void runInBackground(final Runnable runnable) {
        this.vertx.getBackgroundPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Redeployer.this.vertx.setContext(null);
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    log.error("Failed to run task", t);
                }
                finally {
                    Redeployer.this.vertx.setContext(null);
                }
            }
        });
    }

    private static final class FileInfo {
        long lastModified;
        long length;

        private FileInfo(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }
    }
}

