/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.common.util.Strings;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.MavenResolvers;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import io.fabric8.tooling.archetype.generator.ArchetypeHelper;
import io.fabric8.utils.shell.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-generate", scope="fabric", description="Generates a new project from a fabric Maven archetype", detailedDescription="classpath:archetypeGenerate.txt")
public class ArchetypeGenerateAction
extends AbstractAction {
    @Argument(index=0, name="archetype", description="Archetype id, or coordinate, or filter", required=false, multiValued=false)
    private String archetypeOrFilter;
    @Option(name="-d", aliases={"--directory"}, description="To use a specific directory as base for where the project is created (by default the current workspace location is used)", required=false, multiValued=false)
    private String directory;
    private final ArchetypeService archetypeService;

    public ArchetypeGenerateAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        String confirm;
        if (this.directory == null) {
            Preferences preferences = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            String location = preferences.get("workspace", null);
            if (location == null) {
                System.out.println("No workspace location has been set.");
                System.out.println("Use the archetype-workspace command to set a workspace first.");
                System.out.println("");
                return null;
            }
            System.out.println("Using current workspace: " + location);
            this.directory = location;
        } else {
            System.out.println("Using directory as workspace: " + this.directory);
        }
        File target = new File(this.directory);
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.exists() || !target.isDirectory()) {
            System.err.println("Workspace does not exists or is not a directory: " + this.directory);
            return null;
        }
        Archetype archetype = null;
        if (!Strings.isNullOrBlank((String)this.archetypeOrFilter) && (archetype = this.archetypeService.getArchetypeByArtifact(this.archetypeOrFilter)) == null) {
            archetype = this.archetypeService.getArchetype(this.archetypeOrFilter);
        }
        block2: while (archetype == null) {
            List archetypes = this.archetypeService.listArchetypes(this.archetypeOrFilter, true);
            System.out.println("Choose archetype:");
            Iterator it = archetypes.iterator();
            int i = 0;
            while (it.hasNext()) {
                Archetype select = (Archetype)it.next();
                System.out.println(String.format("%4d: -> %-50s %s", ++i, select.artifactId, select.description));
            }
            boolean choosing = true;
            while (choosing) {
                String choose = ShellUtils.readLine(this.session, String.format("Choose a number or apply filter (case insensitive): %d: ", i), false);
                if (Strings.isNullOrBlank((String)choose)) {
                    choose = "" + i;
                }
                try {
                    int no = Integer.valueOf(choose);
                    if (no >= 1 && no <= archetypes.size()) {
                        archetype = (Archetype)archetypes.get(no - 1);
                        continue block2;
                    }
                    System.out.println("Number " + no + " out of range. Please try again!");
                }
                catch (NumberFormatException e) {
                    this.archetypeOrFilter = choose;
                    choosing = false;
                    archetype = null;
                }
            }
        }
        File archetypeFile = this.fetchArchetype(archetype);
        if (archetypeFile == null || !archetypeFile.exists()) {
            System.err.println("No archetype found for \"" + this.archetypeOrFilter + "\" coordinates");
            return null;
        }
        System.out.println("----------------------------------------------------------------------------");
        System.out.println("Using archetype: " + archetype.artifactId);
        String defaultGroupId = "io.fabric8";
        String defaultArtifactId = archetype.artifactId + "-example";
        String defaultVersion = "1.0-SNAPSHOT";
        String defaultName = archetype.name;
        String defaultDescription = Strings.isNotBlank((String)archetype.description) ? archetype.description : "";
        System.out.println("----- Configure archetype -----");
        String groupId = ShellUtils.readLine(this.session, String.format("Define value for property 'groupId' (%s): ", defaultGroupId), false);
        String artifactId = ShellUtils.readLine(this.session, String.format("Define value for property 'artifactId' (%s): ", defaultArtifactId), false);
        String version = ShellUtils.readLine(this.session, String.format("Define value for property 'version' (%s): ", defaultVersion), false);
        groupId = Strings.isNullOrBlank((String)groupId) ? defaultGroupId : groupId;
        artifactId = Strings.isNullOrBlank((String)artifactId) ? defaultArtifactId : artifactId;
        version = Strings.isNullOrBlank((String)version) ? defaultVersion : version;
        String defaultPackageName = (groupId + "." + artifactId).replaceAll("-", ".");
        String packageName = ShellUtils.readLine(this.session, String.format("Define value for property 'package' (%s): ", defaultPackageName), false);
        String defaultDirectoryName = Strings.isNullOrBlank((String)artifactId) ? defaultArtifactId : artifactId;
        this.directory = ShellUtils.readLine(this.session, String.format("Define value for property 'directoryName' (%s): ", defaultDirectoryName), false);
        packageName = Strings.isNullOrBlank((String)packageName) ? defaultPackageName : packageName;
        this.directory = Strings.isNullOrBlank((String)this.directory) ? artifactId : this.directory;
        String name = ShellUtils.readLine(this.session, String.format("Define value for property 'name' (%s): ", defaultName), false);
        String description = ShellUtils.readLine(this.session, String.format("Define value for property 'description' (%s): ", defaultDescription), false);
        name = Strings.isNullOrBlank((String)name) ? null : name;
        description = Strings.isNullOrBlank((String)description) ? null : description;
        File childDir = new File(target, this.directory);
        ArchetypeHelper helper = new ArchetypeHelper(archetypeFile, childDir, groupId, artifactId, version, name, description);
        helper.setPackageName(packageName);
        Map properties = helper.parseProperties();
        String profile = null;
        if (properties.containsKey("fabric8-profile")) {
            profile = (String)properties.remove("fabric8-profile");
            String defaultProfile = Strings.isNullOrBlank((String)profile) ? artifactId : profile;
            String p = ShellUtils.readLine(this.session, String.format("Define value for property 'fabric8.profile' (%s): ", defaultProfile), false);
            profile = Strings.isNullOrBlank((String)p) ? defaultProfile : p;
        }
        boolean mustChoose = false;
        if (!properties.isEmpty()) {
            for (String value : properties.values()) {
                if (!Strings.isNullOrBlank((String)value) && !value.contains("$")) continue;
                mustChoose = true;
                break;
            }
            if (!mustChoose) {
                System.out.println("----- Additional properties -----");
                for (String key : properties.keySet()) {
                    System.out.println(String.format("Using property '%s' (%s): ", key, properties.get(key)));
                }
            }
            boolean choosing = true;
            while (mustChoose || choosing) {
                String confirm2 = null;
                if (!mustChoose) {
                    confirm2 = ShellUtils.readLine(this.session, "Confirm additional properties configuration: (Y): ", false);
                    String string = confirm2 = Strings.isNullOrBlank((String)confirm2) ? "Y" : confirm2;
                }
                if (mustChoose || !"Y".equalsIgnoreCase(confirm2)) {
                    if (!properties.isEmpty()) {
                        System.out.println("----- Configure additional properties -----");
                        for (String key : properties.keySet()) {
                            String p;
                            String value = (String)properties.get(key);
                            if (Strings.isNullOrBlank((String)value) || value.contains("$")) {
                                value = "";
                            }
                            p = Strings.isNullOrBlank((String)(p = ShellUtils.readLine(this.session, String.format("Define value for property '%s' (%s): ", key, value), false))) ? value : p;
                            properties.put(key, p);
                        }
                    }
                    mustChoose = false;
                    continue;
                }
                choosing = false;
            }
        }
        if (profile != null) {
            properties.put("fabric8-profile", profile);
        }
        if (!properties.isEmpty()) {
            helper.setOverrideProperties(properties);
        }
        String string = confirm = (confirm = ShellUtils.readLine(this.session, "Create project: (Y): ", false)) == null || confirm.trim().equals("") ? "Y" : confirm;
        if ("Y".equalsIgnoreCase(confirm)) {
            System.out.println("----------------------------------------------------------------------------");
            System.out.println(String.format("Creating project in directory: %s", childDir.getCanonicalPath()));
            helper.execute();
            System.out.println("Project created successfully");
            System.out.println("");
        } else {
            System.out.println("----------------------------------------------------------------------------");
            System.out.println("Creating project aborted!");
            System.out.println("");
        }
        return null;
    }

    private File fetchArchetype(Archetype archetype) throws IOException {
        MavenResolver resolver = MavenResolvers.createMavenResolver(new Hashtable(), (String)"org.ops4j.pax.url.mvn");
        DownloadManager dm = DownloadManagers.createDownloadManager((MavenResolver)resolver, (ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
        final AtomicReference file = new AtomicReference();
        String url = String.format("mvn:%s/%s/%s", archetype.groupId, archetype.artifactId, archetype.version);
        Downloader downloader = dm.createDownloader();
        downloader.download(url, new DownloadCallback(){

            public void downloaded(StreamProvider provider) throws Exception {
                file.set(provider.getFile());
            }
        });
        try {
            boolean init = false;
            for (int i = 0; i < 120 && file.get() == null; ++i) {
                if (i > 3) {
                    if (!init) {
                        System.out.print("Downloading archetype in progress: ");
                        init = true;
                    }
                    System.out.print(".");
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            System.err.println("\nFailed to download " + archetype);
            throw new IOException(e.getMessage(), e);
        }
        try {
            downloader.await();
            return (File)file.get();
        }
        catch (Exception e) {
            System.err.println("\nFailed to download archetype within 60 seconds: " + archetype);
            throw new IOException("Failed to download archetype within 60 seconds: " + archetype);
        }
    }
}

