/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.commands.ArchetypeInfoAction;
import io.fabric8.tooling.archetype.commands.support.ArchetypeShortCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"archetype-info"})})
public class ArchetypeInfo
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "archetype-info";
    public static final String DESCRIPTION = "Displays information about a fabric Maven archetype";
    @CompleterValues(index=0)
    @Reference(referenceInterface=ArchetypeShortCompleter.class, bind="bindArchetypeCompleter", unbind="unbindArchetypeCompleter")
    private ArchetypeShortCompleter archetypeCompleter;
    @Reference(referenceInterface=ArchetypeService.class)
    private final ValidatingReference<ArchetypeService> archetypeService = new ValidatingReference();

    public Action createNewAction() {
        this.assertValid();
        return new ArchetypeInfoAction((ArchetypeService)this.archetypeService.get());
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    void bindArchetypeCompleter(ArchetypeShortCompleter completer) {
        this.bindCompleter(completer);
    }

    void unbindArchetypeCompleter(ArchetypeShortCompleter completer) {
        this.unbindCompleter(completer);
    }

    public void bindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService.bind((Object)archetypeService);
    }

    public void unbindArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService.unbind((Object)archetypeService);
    }
}

