/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.archetype.commands;

import io.fabric8.tooling.archetype.ArchetypeService;
import io.fabric8.tooling.archetype.catalog.Archetype;
import io.fabric8.utils.TablePrinter;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="archetype-list", scope="fabric", description="List all available fabric Maven archetypes")
public class ArchetypeListAction
extends AbstractAction {
    @Option(name="-v", aliases={"--verbose"}, description="Flag for verbose output", multiValued=false, required=false)
    private boolean verbose;
    private final ArchetypeService archetypeService;

    public ArchetypeListAction(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
    }

    protected Object doExecute() throws Exception {
        TablePrinter table = new TablePrinter();
        if (this.verbose) {
            table.columns("groupId", "artifactId", "version", "description");
        } else {
            table.columns("artifactId", "description");
        }
        for (Archetype archetype : this.archetypeService.listArchetypes()) {
            if (this.verbose) {
                table.row(archetype.groupId, archetype.artifactId, archetype.version, archetype.description);
                continue;
            }
            table.row(archetype.artifactId, archetype.description);
        }
        table.print();
        return null;
    }
}

