/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.extender.listener;

import io.fabric8.api.ModuleStatus;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.extender.listener.FabricBlueprintBundleListener;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractExtenderListener
extends AbstractComponent
implements BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricBlueprintBundleListener.class);
    @GuardedBy(value="ConcurrentMap")
    private final ConcurrentMap<Long, ModuleStatus> statusMap = new ConcurrentHashMap<Long, ModuleStatus>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    String runtimeIdentity;

    void activate(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        this.activateComponent();
    }

    void deactivate(BundleContext bundleContext) {
        this.deactivateComponent();
        bundleContext.removeBundleListener((BundleListener)this);
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected abstract String getExtenderType();

    void update(final String runtimeIdentity, final long bundleId, final ModuleStatus bundleStatus, final ModuleStatus extenderStatus) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (AbstractExtenderListener.this.isValid()) {
                    String extender = AbstractExtenderListener.this.getExtenderType();
                    try {
                        if (bundleStatus != null) {
                            ZooKeeperUtils.setData((CuratorFramework)AbstractExtenderListener.this.getCurator(), (String)ZkPath.CONTAINER_EXTENDER_BUNDLE.getPath(new String[]{runtimeIdentity, extender, String.valueOf(bundleId)}), (String)bundleStatus.name(), (CreateMode)CreateMode.EPHEMERAL);
                        } else {
                            ZooKeeperUtils.delete((CuratorFramework)AbstractExtenderListener.this.getCurator(), (String)ZkPath.CONTAINER_EXTENDER_BUNDLE.getPath(new String[]{runtimeIdentity, extender, String.valueOf(bundleId)}));
                        }
                        ZooKeeperUtils.setData((CuratorFramework)AbstractExtenderListener.this.getCurator(), (String)ZkPath.CONTAINER_EXTENDER_STATUS.getPath(new String[]{runtimeIdentity, extender}), (String)extenderStatus.name(), (CreateMode)CreateMode.EPHEMERAL);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Failed to update status of bundle {} for extender {}.", (Object)bundleId, (Object)extender);
                    }
                }
            }
        });
    }

    public void bundleChanged(BundleEvent event) {
        long bundleId = event.getBundle().getBundleId();
        if (event.getType() == 16) {
            this.statusMap.remove(bundleId);
            this.update(this.runtimeIdentity, bundleId, null, this.getExtenderStatus());
        }
    }

    public void updateBundle(long bundleId, ModuleStatus moduleStatus) {
        this.statusMap.put(bundleId, moduleStatus);
        this.update(this.runtimeIdentity, bundleId, moduleStatus, this.getExtenderStatus());
    }

    protected ModuleStatus getExtenderStatus() {
        int starting = 0;
        int failed = 0;
        int waiting = 0;
        int stopping = 0;
        for (Map.Entry entry : this.statusMap.entrySet()) {
            ModuleStatus moduleStatus = (ModuleStatus)entry.getValue();
            if (moduleStatus == ModuleStatus.FAILED) {
                ++failed;
                continue;
            }
            if (moduleStatus == ModuleStatus.WAITING) {
                ++waiting;
                continue;
            }
            if (moduleStatus == ModuleStatus.STOPPING) {
                ++stopping;
                continue;
            }
            if (moduleStatus != ModuleStatus.STARTING) continue;
            ++starting;
        }
        if (failed > 0) {
            return ModuleStatus.FAILED;
        }
        if (waiting > 0) {
            return ModuleStatus.WAITING;
        }
        if (stopping > 0) {
            return ModuleStatus.STOPPING;
        }
        if (starting > 0) {
            return ModuleStatus.STARTING;
        }
        return ModuleStatus.STARTED;
    }

    protected CuratorFramework getCurator() {
        return (CuratorFramework)this.curator.get();
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }
}

