/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.LockHandle;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.Ports;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.curator.CuratorACLManager;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreBootstrapTemplate
implements DataStoreTemplate {
    static final Logger LOGGER = LoggerFactory.getLogger(DataStoreBootstrapTemplate.class);
    private final String connectionUrl;
    private final CreateEnsembleOptions options;
    private final String name;
    private final File homeDir;
    private final CuratorACLManager aclManager = new CuratorACLManager();

    public DataStoreBootstrapTemplate(BootstrapConfiguration.DataStoreOptions bootOptions) {
        this.name = bootOptions.getContainerId();
        this.homeDir = bootOptions.getHomeDir();
        this.connectionUrl = bootOptions.getConnectionUrl();
        this.options = bootOptions.getCreateOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWith(ProfileRegistry profileRegistry, DataStore dataStore) throws Exception {
        String versionId = this.options.getVersion();
        int minimumPort = this.options.getMinimumPort();
        int maximumPort = this.options.getMaximumPort();
        String zooKeeperServerHost = this.options.getBindAddress();
        int zooKeeperServerPort = this.options.getZooKeeperServerPort();
        int zooKeeperServerConnectionPort = this.options.getZooKeeperServerConnectionPort();
        int mappedPort = Ports.mapPortToRange(zooKeeperServerPort, minimumPort, maximumPort);
        try (CuratorFramework curator = null;){
            curator = this.createCuratorFramework(this.connectionUrl, this.options);
            curator.start();
            curator.getZookeeperClient().blockUntilConnectedOrTimedOut();
            LockHandle writeLock = profileRegistry.aquireWriteLock();
            try {
                Properties agentProps;
                ProfileBuilder builder;
                File importPath = new File(this.options.getImportPath());
                if (!importPath.isAbsolute()) {
                    importPath = new File(this.homeDir, this.options.getImportPath());
                }
                if (this.options.isAutoImportEnabled()) {
                    if (importPath.isDirectory()) {
                        profileRegistry.importFromFileSystem(importPath.getAbsolutePath());
                    } else {
                        LOGGER.warn("Profile import dir does not exist: {}", (Object)importPath);
                    }
                }
                ZooKeeperUtils.setData(curator, ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), versionId);
                Map<String, String> jaasConfig = Collections.singletonMap("encryption.enabled", "${zk:/fabric/authentication/encryption.enabled}");
                Properties zkProps = new Properties();
                zkProps.setProperty("zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
                zkProps.setProperty("zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
                Profile defaultProfile = profileRegistry.getProfile(versionId, "default");
                if (defaultProfile == null) {
                    ProfileBuilder prfBuilder = ProfileBuilder.Factory.create((String)versionId, (String)"default");
                    prfBuilder.addConfiguration("io.fabric8.jaas", jaasConfig);
                    prfBuilder.addFileConfiguration("io.fabric8.zookeeper.properties", DataStoreUtils.toBytes(zkProps));
                    Profile profile = prfBuilder.getProfile();
                    if (profileRegistry.hasVersion(versionId)) {
                        profileRegistry.createProfile(profile);
                    } else {
                        VersionBuilder verBuilder = VersionBuilder.Factory.create((String)versionId);
                        Version version = verBuilder.addProfile(profile).getVersion();
                        profileRegistry.createVersion(version);
                    }
                } else {
                    ProfileBuilder builder2 = ProfileBuilder.Factory.createFrom((Profile)defaultProfile);
                    builder2.addConfiguration("io.fabric8.jaas", jaasConfig);
                    builder2.addFileConfiguration("io.fabric8.zookeeper.properties", DataStoreUtils.toBytes(zkProps));
                    profileRegistry.updateProfile(builder2.getProfile());
                }
                ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), "${zk:" + this.name + "/ip}:" + zooKeeperServerConnectionPort);
                ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), PasswordEncoder.encode(this.options.getZookeeperPassword()));
                Properties ensembleProps = new Properties();
                ensembleProps.put("tickTime", String.valueOf(this.options.getZooKeeperServerTickTime()));
                ensembleProps.put("initLimit", String.valueOf(this.options.getZooKeeperServerInitLimit()));
                ensembleProps.put("syncLimit", String.valueOf(this.options.getZooKeeperServerSyncLimit()));
                ensembleProps.put("dataDir", this.options.getZooKeeperServerDataDir() + File.separator + "0000");
                this.loadPropertiesFrom(ensembleProps, importPath + "/fabric/profiles/default.profile/io.fabric8.zookeeper.server.properties");
                String profileId = "fabric-ensemble-0000";
                IllegalStateAssertion.assertFalse((Boolean)profileRegistry.hasProfile(versionId, profileId), (String)("Profile already exists: " + versionId + "/" + profileId));
                ProfileBuilder ensembleProfileBuilder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
                ((ProfileBuilder)ensembleProfileBuilder.addAttribute("abstract", "true")).addAttribute("hidden", "true");
                ensembleProfileBuilder.addFileConfiguration("io.fabric8.zookeeper.server-0000.properties", DataStoreUtils.toBytes(ensembleProps));
                String ensembleProfileId = profileRegistry.createProfile(ensembleProfileBuilder.getProfile());
                Properties serverProps = new Properties();
                serverProps.put("clientPort", String.valueOf(mappedPort));
                serverProps.put("clientPortAddress", zooKeeperServerHost);
                profileId = "fabric-ensemble-0000-1";
                IllegalStateAssertion.assertFalse((Boolean)profileRegistry.hasProfile(versionId, profileId), (String)("Profile already exists: " + versionId + "/" + profileId));
                ProfileBuilder serverProfileBuilder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
                ((ProfileBuilder)serverProfileBuilder.addAttribute("hidden", "true")).addAttribute("parents", ensembleProfileId);
                serverProfileBuilder.addFileConfiguration("io.fabric8.zookeeper.server-0000.properties", DataStoreUtils.toBytes(serverProps));
                profileRegistry.createProfile(serverProfileBuilder.getProfile());
                ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]), "0000");
                ZooKeeperUtils.setData(curator, ZkPath.CONFIG_ENSEMBLE.getPath("0000"), this.name);
                Profile fabricProfile = profileRegistry.getProfile(versionId, "fabric");
                if (fabricProfile == null) {
                    builder = ProfileBuilder.Factory.create((String)versionId, (String)"fabric");
                    agentProps = new Properties();
                    agentProps.put("feature.fabric-commands", "fabric-commands");
                    builder.addFileConfiguration("io.fabric8.agent.properties", DataStoreUtils.toBytes(agentProps));
                    String createdId = profileRegistry.createProfile(builder.getProfile());
                    fabricProfile = profileRegistry.getRequiredProfile(versionId, createdId);
                } else {
                    builder = ProfileBuilder.Factory.createFrom((Profile)fabricProfile);
                    agentProps = DataStoreUtils.toProperties(fabricProfile.getFileConfiguration("io.fabric8.agent.properties"));
                    agentProps.put("feature.fabric-commands", "fabric-commands");
                    builder.addFileConfiguration("io.fabric8.agent.properties", DataStoreUtils.toBytes(agentProps));
                    String updatedId = profileRegistry.updateProfile(builder.getProfile());
                    fabricProfile = profileRegistry.getRequiredProfile(versionId, updatedId);
                }
            }
            finally {
                writeLock.unlock();
            }
            ZooKeeperUtils.createDefault(curator, ZkPath.CONFIG_CONTAINER.getPath(this.name), versionId);
            StringBuilder profilesBuilder = new StringBuilder();
            Set profiles = this.options.getProfiles();
            profilesBuilder.append("fabric").append(" ").append("fabric-ensemble-0000-1");
            for (String p : profiles) {
                profilesBuilder.append(" ").append(p);
            }
            if (!this.options.isAgentEnabled()) {
                profilesBuilder.append(" ").append("unmanaged");
            }
            ZooKeeperUtils.createDefault(curator, ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(versionId, this.name), profilesBuilder.toString());
            EncryptionSupport encryption = this.addUsersToZookeeper(curator, this.options.getUsers());
            ZooKeeperUtils.createDefault(curator, "/fabric/authentication/encryption.enabled", Boolean.valueOf(encryption != null).toString());
            ZooKeeperUtils.createDefault(curator, "/fabric/authentication/domain", "karaf");
            ZooKeeperUtils.createDefault(curator, ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]), "PBEWithMD5AndDES");
            ZooKeeperUtils.createDefault(curator, ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]), PasswordEncoder.encode(this.options.getZookeeperPassword()));
            this.aclManager.fixAcl(curator, "/fabric", true);
        }
    }

    private CuratorFramework createCuratorFramework(String connectionUrl, CreateEnsembleOptions options) throws IOException {
        return CuratorFrameworkFactory.builder().connectString(connectionUrl).connectionTimeoutMs(15000).sessionTimeoutMs(60000).aclProvider(this.aclManager).authorization("digest", ("fabric:" + options.getZookeeperPassword()).getBytes()).retryPolicy(new RetryNTimes(3, 500)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Properties targetProperties, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                targetProperties.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private EncryptionSupport addUsersToZookeeper(CuratorFramework curator, Map<String, String> users) throws Exception {
        Pattern p = Pattern.compile("([^,]+),(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("encryption.prefix", "{CRYPT}");
        options.put("encryption.suffix", "{CRYPT}");
        options.put("encryption.enabled", "true");
        options.put("encryption.algorithm", "MD5");
        options.put("encryption.encoding", "hexadecimal");
        Encryption encryption = null;
        EncryptionSupport encryptionSupport = null;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            options.put(BundleContext.class.getName(), (String)bundle.getBundleContext());
            try {
                encryptionSupport = new EncryptionSupport(options);
                encryption = encryptionSupport.getEncryption();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : users.entrySet()) {
            String user = entry.getKey();
            Matcher m = p.matcher(entry.getValue());
            if (!m.matches() || m.groupCount() < 2) continue;
            String password = m.group(1).trim();
            if (!(encryptionSupport == null || encryption == null || password.startsWith(encryptionSupport.getEncryptionPrefix()) && password.endsWith(encryptionSupport.getEncryptionSuffix()))) {
                password = encryptionSupport.getEncryptionPrefix() + encryption.encryptPassword(m.group(1)).trim() + encryptionSupport.getEncryptionSuffix();
            }
            String roles = m.group(2).trim();
            sb.append(user).append("=").append(password).append(",").append(roles).append("\n");
        }
        String allUsers = sb.toString();
        ZooKeeperUtils.createDefault(curator, "/fabric/authentication/users", allUsers);
        return encryptionSupport;
    }

    public String toString() {
        return "DataStoreBootstrapTemplate{name='" + this.name + '\'' + ", connectionUrl='" + this.connectionUrl + '\'' + '}';
    }
}

