/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.utils;

import io.fabric8.common.util.Strings;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperFacade {
    private final CuratorFramework curator;

    public ZooKeeperFacade(CuratorFramework curator) {
        this.curator = curator;
    }

    public List<String> matchingDescendantStringData(String pattern) throws Exception {
        List<String> paths = this.matchingDescendants(pattern);
        ArrayList<String> answer = new ArrayList<String>();
        for (String path : paths) {
            String text = this.getStringData(path);
            if (!Strings.isNotBlank((String)text)) continue;
            answer.add(text);
        }
        return answer;
    }

    public List<String> matchingDescendants(String pattern) throws Exception {
        String[] paths = pattern.split("/?\\*/?");
        if (paths.length == 0) {
            return this.getAllChildren(paths[0]);
        }
        if (paths.length > 0) {
            return this.walkDescendants(paths, 0, paths[0]);
        }
        return new ArrayList<String>();
    }

    protected List<String> walkDescendants(String[] paths, int index, String prefix) throws Exception {
        boolean isLast;
        boolean bl = isLast = index >= paths.length - 1;
        if (isLast) {
            List<String> allChildren = this.getAllChildren(prefix);
            if (this.exists(prefix) != null) {
                allChildren.add(prefix);
            }
            return allChildren;
        }
        ArrayList<String> answer = new ArrayList<String>();
        List<String> children = this.getChildren(prefix);
        int nextIndex = index + 1;
        String nextPath = paths[nextIndex];
        for (String child : children) {
            String childPrefix = prefix + "/" + child + "/" + nextPath;
            List<String> childResults = this.walkDescendants(paths, nextIndex, childPrefix);
            answer.addAll(childResults);
        }
        return answer;
    }

    public String getStringData(String path) throws Exception {
        return ZooKeeperUtils.getStringData(this.curator, path);
    }

    public List<String> getChildren(String path) throws Exception {
        return ZooKeeperUtils.getChildrenSafe(this.curator, path);
    }

    public List<String> getAllChildren(String path) throws Exception {
        List<String> children = this.getChildren(path);
        ArrayList<String> allChildren = new ArrayList<String>();
        for (String child : children) {
            String fullPath = ZKPaths.makePath(path, child);
            allChildren.add(fullPath);
            allChildren.addAll(this.getAllChildren(fullPath));
        }
        return allChildren;
    }

    public void create(String path) throws Exception {
        ZooKeeperUtils.create(this.curator, path);
    }

    public String create(String path, CreateMode createMode) throws Exception {
        return ZooKeeperUtils.create(this.curator, path, createMode);
    }

    public String create(String path, String data, CreateMode createMode) throws Exception {
        return ZooKeeperUtils.create(this.curator, path, data, createMode);
    }

    public String create(String path, byte[] data, CreateMode createMode) throws Exception {
        return ZooKeeperUtils.create(this.curator, path, data, createMode);
    }

    public void delete(String path) throws Exception {
        ZooKeeperUtils.deleteSafe(this.curator, path);
    }

    public Stat exists(String path) throws Exception {
        return ZooKeeperUtils.exists(this.curator, path);
    }

    public long lastModified(String path) throws Exception {
        long lastModified = 0L;
        List<String> children = this.getChildren(path);
        if (children.isEmpty()) {
            return this.exists(path).getMtime();
        }
        for (String child : children) {
            lastModified = Math.max(this.lastModified(path + "/" + child), lastModified);
        }
        return lastModified;
    }
}

