/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.impl.MavenDownloadManager;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.MavenResolvers;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.maven.settings.Mirror;

public final class DownloadManagers {
    public static DownloadManager createDownloadManager(FabricService fabricService, ScheduledExecutorService executorService) {
        Profile overlayProfile = fabricService.getCurrentContainer().getOverlayProfile();
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)fabricService, (Profile)overlayProfile);
        return DownloadManagers.createDownloadManager(fabricService, effectiveProfile, executorService);
    }

    public static DownloadManager createDownloadManager(FabricService fabricService, Profile profile, ScheduledExecutorService executorService) {
        HashMap configuration = profile.getConfiguration("io.fabric8.agent");
        if (configuration == null) {
            configuration = new HashMap();
        }
        Dictionary<String, String> properties = DownloadManagers.mapToDictionary(configuration);
        Mirror mirror = AgentUtils.getMavenProxy(fabricService);
        MavenResolver resolver = MavenResolvers.createMavenResolver((Mirror)mirror, properties, (String)"org.ops4j.pax.url.mvn");
        return DownloadManagers.createDownloadManager(resolver, executorService);
    }

    public static DownloadManager createDownloadManager(MavenResolver resolver, ScheduledExecutorService executorService) {
        return new MavenDownloadManager(resolver, executorService);
    }

    private static Dictionary<String, String> mapToDictionary(Map<String, String> map) {
        Hashtable<String, String> p = new Hashtable<String, String>();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }

    private DownloadManagers() {
    }
}

