/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.region;

import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.region.AbstractRegionDigraphVisitor;
import io.fabric8.agent.region.CandidateComparator;
import io.fabric8.agent.region.Subsystem;
import io.fabric8.agent.repository.BaseRepository;
import io.fabric8.agent.resolver.CapabilityImpl;
import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.ResourceUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class SubsystemResolveContext
extends ResolveContext {
    private final Subsystem root;
    private final RegionDigraph digraph;
    private final Set<Resource> mandatory = new HashSet<Resource>();
    private final CandidateComparator candidateComparator = new CandidateComparator(this.mandatory);
    private final Map<Resource, Subsystem> resToSub = new HashMap<Resource, Subsystem>();
    private final Repository repository;
    private final Repository globalRepository;
    private final Downloader downloader;

    public SubsystemResolveContext(Subsystem root, RegionDigraph digraph, Repository globalRepository, Downloader downloader) throws BundleException {
        this.root = root;
        this.digraph = digraph;
        this.globalRepository = globalRepository != null ? new SubsystemRepository(globalRepository) : null;
        this.downloader = downloader;
        this.prepare(root);
        this.repository = new BaseRepository(this.resToSub.keySet());
        this.findMandatory(root);
    }

    void findMandatory(Resource res) {
        if (this.mandatory.add(res)) {
            for (Requirement req : res.getRequirements(null)) {
                List<Capability> caps;
                String resolution = (String)req.getDirectives().get("resolution");
                if ("optional".equals(resolution) || (caps = this.findProviders(req)).size() != 1) continue;
                this.findMandatory(caps.get(0).getResource());
            }
        }
    }

    void prepare(Subsystem subsystem) {
        this.resToSub.put(subsystem, subsystem);
        for (Resource res : subsystem.getInstallable()) {
            this.resToSub.put(res, subsystem);
        }
        for (Subsystem child : subsystem.getChildren()) {
            this.prepare(child);
        }
    }

    @Override
    public Collection<Resource> getMandatoryResources() {
        return Collections.singleton(this.root);
    }

    @Override
    public List<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> caps = new ArrayList<Capability>();
        Region requirerRegion = this.getRegion(requirement.getResource());
        if (requirerRegion != null) {
            Collection<Capability> res;
            Map<Requirement, Collection<Capability>> resMap = this.repository.findProviders(Collections.singleton(requirement));
            Collection<Capability> collection = res = resMap != null ? resMap.get(requirement) : null;
            if (res != null && !res.isEmpty()) {
                caps.addAll(res);
            } else if (this.globalRepository != null && !"optional".equals(requirement.getDirectives().get("resolution"))) {
                resMap = this.globalRepository.findProviders(Collections.singleton(requirement));
                Collection<Capability> collection2 = res = resMap != null ? resMap.get(requirement) : null;
                if (res != null && !res.isEmpty()) {
                    caps.addAll(res);
                }
            }
            Visitor visitor = new Visitor(caps);
            requirerRegion.visitSubgraph(visitor);
            Collection allowed = visitor.getAllowed();
            caps.retainAll(allowed);
            if (caps.size() > 1) {
                HashMap<String, Resource> providers = new HashMap<String, Resource>();
                for (Capability cap : caps) {
                    Resource resource = cap.getResource();
                    String id = ResourceUtils.getSymbolicName(resource) + "|" + ResourceUtils.getVersion(resource);
                    Resource prev = (Resource)providers.get(id);
                    if (prev != null && prev != resource) {
                        Region r1 = this.getRegion(prev);
                        Region r2 = this.getRegion(resource);
                        boolean r2canSeeR1 = this.isResourceVisibleFromRegion(prev, r2);
                        boolean r1canSeeR2 = this.isResourceVisibleFromRegion(resource, r1);
                        if (r1canSeeR2 && r2canSeeR1) {
                            int reqDiff = prev.getRequirements(null).size() - resource.getRequirements(null).size();
                            if (reqDiff == 0) {
                                String r2Name;
                                String r1Name = this.getRegion(prev).getName();
                                int c = r1Name.compareTo(r2Name = this.getRegion(resource).getName());
                                if (c == 0) {
                                    c = prev instanceof BundleRevision ? -1 : 1;
                                }
                                resource = c < 0 ? prev : resource;
                            } else {
                                resource = reqDiff < 0 ? prev : resource;
                            }
                        } else {
                            resource = r1canSeeR2 ? prev : resource;
                        }
                    }
                    providers.put(id, resource);
                }
                Iterator it = caps.iterator();
                while (it.hasNext()) {
                    Capability cap;
                    cap = (Capability)it.next();
                    if (providers.values().contains(cap.getResource())) continue;
                    it.remove();
                }
            }
            Collections.sort(caps, this.candidateComparator);
        }
        return caps;
    }

    private boolean isResourceVisibleFromRegion(Resource resource, Region region) {
        AbstractRegionDigraphVisitor<Resource> visitor = new AbstractRegionDigraphVisitor<Resource>(Collections.singletonList(resource)){

            @Override
            protected boolean contains(Region region, Resource candidate) {
                return SubsystemResolveContext.this.getRegion(candidate).equals(region);
            }

            @Override
            protected boolean isAllowed(Resource resource, RegionFilter filter) {
                List identities = resource.getCapabilities("osgi.identity");
                if (identities != null && !identities.isEmpty()) {
                    Capability identity = (Capability)identities.iterator().next();
                    HashMap attrs = new HashMap();
                    attrs.put("bundle-symbolic-name", identity.getAttributes().get("osgi.identity"));
                    attrs.put("bundle-version", identity.getAttributes().get("version"));
                    return filter.isAllowed("org.eclipse.equinox.allow.bundle", attrs);
                }
                return false;
            }
        };
        region.visitSubgraph(visitor);
        return !visitor.getAllowed().isEmpty();
    }

    private Subsystem getSubsystem(Resource resource) {
        return this.resToSub.get(resource);
    }

    private Region getRegion(Resource resource) {
        return this.digraph.getRegion(this.getSubsystem(resource).getName());
    }

    @Override
    public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
        int idx = Collections.binarySearch(capabilities, hostedCapability, this.candidateComparator);
        if (idx < 0) {
            idx = Math.abs(idx + 1);
        }
        capabilities.add(idx, hostedCapability);
        return idx;
    }

    @Override
    public boolean isEffective(Requirement requirement) {
        return true;
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return Collections.emptyMap();
    }

    class SubsystemRepository
    implements Repository {
        private final Repository repository;
        private final Map<Subsystem, Map<Capability, Capability>> mapping = new HashMap<Subsystem, Map<Capability, Capability>>();

        public SubsystemRepository(Repository repository) {
            this.repository = repository;
        }

        @Override
        public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
            Map<Requirement, Collection<Capability>> base = this.repository.findProviders(requirements);
            HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
            for (Map.Entry<Requirement, Collection<Capability>> entry : base.entrySet()) {
                ArrayList<Capability> caps = new ArrayList<Capability>();
                Subsystem ss = SubsystemResolveContext.this.getSubsystem(entry.getKey().getResource());
                while (!ss.isAcceptDependencies()) {
                    ss = ss.getParent();
                }
                Map<Capability, Capability> map = this.mapping.get(ss);
                if (map == null) {
                    map = new HashMap<Capability, Capability>();
                    this.mapping.put(ss, map);
                }
                for (Capability cap : entry.getValue()) {
                    Capability wrapped = map.get(cap);
                    if (wrapped == null) {
                        this.wrap(map, ss, cap.getResource());
                        wrapped = map.get(cap);
                    }
                    caps.add(wrapped);
                }
                result.put(entry.getKey(), caps);
            }
            return result;
        }

        private void wrap(Map<Capability, Capability> map, Subsystem subsystem, Resource resource) {
            ResourceImpl wrapped = new ResourceImpl();
            for (Capability cap : resource.getCapabilities(null)) {
                CapabilityImpl wCap = new CapabilityImpl(wrapped, cap.getNamespace(), cap.getDirectives(), cap.getAttributes());
                map.put(cap, wCap);
                wrapped.addCapability(wCap);
            }
            for (Requirement req : resource.getRequirements(null)) {
                RequirementImpl wReq = new RequirementImpl(wrapped, req.getNamespace(), req.getDirectives(), req.getAttributes());
                wrapped.addRequirement(wReq);
            }
            ResourceUtils.addIdentityRequirement(wrapped, subsystem, false);
            SubsystemResolveContext.this.resToSub.put(wrapped, subsystem);
            try {
                SubsystemResolveContext.this.downloader.download(ResourceUtils.getUri(wrapped), null);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unable to download resource: " + ResourceUtils.getUri(wrapped));
            }
        }
    }

    class Visitor
    extends AbstractRegionDigraphVisitor<Capability> {
        Visitor(Collection<Capability> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, Capability candidate) {
            return region.equals(SubsystemResolveContext.this.getRegion(candidate.getResource()));
        }

        @Override
        protected boolean isAllowed(Capability candidate, RegionFilter filter) {
            if (filter.isAllowed(candidate.getNamespace(), candidate.getAttributes())) {
                return true;
            }
            Resource resource = candidate.getResource();
            List identities = resource.getCapabilities("osgi.identity");
            if (identities != null && !identities.isEmpty()) {
                Capability identity = (Capability)identities.iterator().next();
                HashMap attrs = new HashMap();
                attrs.put("bundle-symbolic-name", identity.getAttributes().get("osgi.identity"));
                attrs.put("bundle-version", identity.getAttributes().get("version"));
                return filter.isAllowed("org.eclipse.equinox.allow.bundle", attrs);
            }
            return false;
        }
    }
}

