/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.CapabilityImpl;
import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.SimpleFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public final class ResourceUtils {
    public static final String TYPE_SUBSYSTEM = "karaf.subsystem";
    public static final String TYPE_FEATURE = "karaf.feature";

    private ResourceUtils() {
    }

    public static String getSymbolicName(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("osgi.identity").toString();
        }
        return null;
    }

    public static Version getVersion(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return (Version)cap.getAttributes().get("version");
        }
        return null;
    }

    public static String getType(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("type").toString();
        }
        return null;
    }

    public static String getUri(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.content")) continue;
            return cap.getAttributes().get("url").toString();
        }
        return null;
    }

    public static boolean isFragment(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            String type = (String)cap.getAttributes().get("type");
            return type != null && type.equals("osgi.fragment");
        }
        return false;
    }

    public static String getFeatureId(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            Map attributes;
            if (!cap.getNamespace().equals("osgi.identity") || !TYPE_FEATURE.equals((attributes = cap.getAttributes()).get("type"))) continue;
            String name = (String)attributes.get("osgi.identity");
            Version version = (Version)attributes.get("version");
            return version != null ? name + "/" + version : name;
        }
        return null;
    }

    public static void addIdentityRequirement(ResourceImpl resource, String name, String type, String range) {
        ResourceUtils.addIdentityRequirement(resource, name, type, range, true);
    }

    public static void addIdentityRequirement(ResourceImpl resource, String name, String type, String range, boolean mandatory) {
        ResourceUtils.addIdentityRequirement(resource, name, type, range != null ? new VersionRange(range) : null, mandatory);
    }

    public static void addIdentityRequirement(ResourceImpl resource, String name, String type, VersionRange range) {
        ResourceUtils.addIdentityRequirement(resource, name, type, range, true);
    }

    public static void addIdentityRequirement(ResourceImpl resource, String name, String type, VersionRange range, boolean mandatory) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (!mandatory) {
            dirs.put("resolution", "optional");
        }
        if (name != null) {
            attrs.put("osgi.identity", name);
        }
        if (type != null) {
            attrs.put("type", type);
        }
        if (range != null) {
            attrs.put("version", range);
        }
        resource.addRequirement(new RequirementImpl(resource, "osgi.identity", dirs, attrs));
    }

    public static void addIdentityRequirement(ResourceImpl resource, Resource required) {
        ResourceUtils.addIdentityRequirement(resource, required, true);
    }

    public static void addIdentityRequirement(ResourceImpl resource, Resource required, boolean mandatory) {
        for (Capability cap : required.getCapabilities(null)) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            Map attributes = cap.getAttributes();
            HashMap<String, String> dirs = new HashMap<String, String>();
            dirs.put("resolution", mandatory ? "mandatory" : "optional");
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("osgi.identity", attributes.get("osgi.identity"));
            attrs.put("type", attributes.get("type"));
            Version version = (Version)attributes.get("version");
            if (version != null) {
                attrs.put("version", new VersionRange(version, true));
            }
            resource.addRequirement(new RequirementImpl(resource, "osgi.identity", dirs, attrs));
        }
    }

    public static String toFeatureRequirement(String feature) {
        String[] parts = feature.split("/");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", parts[0]);
        attrs.put("type", TYPE_FEATURE);
        if (parts.length > 1) {
            attrs.put("version", new VersionRange(parts[1]));
        }
        HashMap<String, String> dirs = new HashMap<String, String>();
        dirs.put("filter", SimpleFilter.convert(attrs).toString());
        return new RequirementImpl(null, "osgi.identity", dirs, attrs).toString();
    }

    public static String toFeatureCapability(String feature) {
        String[] parts = feature.split("/");
        HashMap<String, String> dirs = new HashMap<String, String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", parts[0]);
        attrs.put("type", TYPE_FEATURE);
        if (parts.length > 1) {
            attrs.put("version", VersionTable.getVersion(parts[1]));
        }
        return new CapabilityImpl(null, "osgi.identity", dirs, attrs).toString();
    }
}

