/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.Macro;
import io.fabric8.agent.internal.MapUtils;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.ConfigFile;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.region.SubsystemResolver;
import io.fabric8.agent.resolver.ResourceUtils;
import io.fabric8.agent.service.BundleComparator;
import io.fabric8.agent.service.Constants;
import io.fabric8.agent.service.MetadataBuilder;
import io.fabric8.agent.service.RequirementSort;
import io.fabric8.agent.service.ResourceComparator;
import io.fabric8.agent.service.State;
import io.fabric8.agent.utils.OsgiUtils;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.MultiException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployer {
    public static final int DISPLAY_LOG = 1;
    public static final int DISPLAY_STDOUT = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(Deployer.class);
    private final DownloadManager manager;
    private final DeployCallback callback;

    public Deployer(DownloadManager manager, DeployCallback callback) {
        this.manager = manager;
        this.callback = callback;
    }

    public void deploy(DeploymentState dstate, DeploymentRequest request) throws Exception {
        boolean bl;
        Object r2;
        boolean noRefreshUnmanaged = request.options.contains((Object)Constants.Option.NoAutoRefreshUnmanagedBundles);
        boolean noRefreshManaged = request.options.contains((Object)Constants.Option.NoAutoRefreshManagedBundles);
        boolean noRefresh = request.options.contains((Object)Constants.Option.NoAutoRefreshBundles);
        boolean noStart = request.options.contains((Object)Constants.Option.NoAutoStartBundles);
        boolean verbose = request.options.contains((Object)Constants.Option.Verbose);
        boolean silent = request.options.contains((Object)Constants.Option.Silent);
        boolean simulate = request.options.contains((Object)Constants.Option.Simulate);
        boolean noManageBundles = request.options.contains((Object)Constants.Option.NoAutoManageBundles);
        int display = silent ? 0 : (verbose ? 3 : 1);
        Map<String, Set<Long>> managedBundles = MapUtils.copy(dstate.state.managedBundles);
        Map<String, Set<Bundle>> unmanagedBundles = MapUtils.apply(MapUtils.diff(dstate.bundlesPerRegion, dstate.state.managedBundles), MapUtils.map(dstate.bundles));
        SubsystemResolver resolver = new SubsystemResolver(this.manager);
        resolver.prepare(dstate.features.values(), request.requirements, MapUtils.apply(unmanagedBundles, this.adapt(BundleRevision.class)));
        Set<String> prereqs = resolver.collectPrerequisites();
        if (!prereqs.isEmpty()) {
            Iterator<String> iterator = prereqs.iterator();
            while (iterator.hasNext()) {
                String prereq = iterator.next();
                String[] parts = prereq.split("/");
                VersionRange range = parts[1].equals("0.0.0") ? VersionRange.ANY_VERSION : (!parts[1].startsWith("[") && !parts[1].startsWith("(") ? new VersionRange(Macro.transform(request.featureResolutionRange, parts[1])) : new VersionRange(parts[1]));
                boolean found = false;
                for (Set<String> featureSet : dstate.state.installedFeatures.values()) {
                    String feature;
                    String[] p;
                    Iterator<String> iterator2 = featureSet.iterator();
                    while (iterator2.hasNext() && !(found = parts[0].equals((p = (feature = iterator2.next()).split("/"))[0]) && range.contains(VersionTable.getVersion(p[1])))) {
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                iterator.remove();
            }
        }
        if (!prereqs.isEmpty()) {
            DeploymentRequest newRequest = new DeploymentRequest();
            newRequest.bundleUpdateRange = request.bundleUpdateRange;
            newRequest.featureResolutionRange = request.featureResolutionRange;
            newRequest.globalRepository = request.globalRepository;
            newRequest.options = request.options;
            newRequest.overrides = request.overrides;
            newRequest.requirements = MapUtils.copy(dstate.state.requirements);
            for (String prereq : prereqs) {
                MapUtils.addToMapSet(newRequest.requirements, "root", prereq);
            }
            newRequest.stateChanges = Collections.emptyMap();
            newRequest.updateSnaphots = request.updateSnaphots;
            this.deploy(dstate, newRequest);
            throw new PartialDeploymentException(prereqs);
        }
        this.callback.phase("resolving");
        resolver.resolve(new MetadataBuilder(request.metadata), request.overrides, request.featureResolutionRange, request.globalRepository);
        Map<String, StreamProvider> providers = resolver.getProviders();
        Map<String, Set<Resource>> featuresPerRegion = resolver.getFeaturesPerRegions();
        Map<String, Set<String>> installedFeatures = MapUtils.apply(featuresPerRegion, this.featureId());
        Map<String, Set<String>> newFeatures = MapUtils.diff(installedFeatures, dstate.state.installedFeatures);
        Map<String, Set<String>> delFeatures = MapUtils.diff(dstate.state.installedFeatures, installedFeatures);
        Map<String, Map<String, String>> stateFeatures = MapUtils.copy(dstate.state.stateFeatures);
        for (Map.Entry<String, Set<String>> entry : delFeatures.entrySet()) {
            Map<String, String> map = stateFeatures.get(entry.getKey());
            if (map == null) continue;
            map.entrySet().removeAll((Collection)entry.getValue());
            if (!map.isEmpty()) continue;
            stateFeatures.remove(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : request.stateChanges.entrySet()) {
            String region = entry.getKey();
            Map<String, String> regionStates = stateFeatures.get(region);
            if (regionStates == null) continue;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                String feature = (String)entry2.getKey();
                if (!regionStates.containsKey(feature)) continue;
                regionStates.put(feature, ((Constants.RequestedState)((Object)entry2.getValue())).name());
            }
        }
        for (Map.Entry<String, Object> entry : newFeatures.entrySet()) {
            for (String feature : (Set)entry.getValue()) {
                Map<String, String> map = stateFeatures.get(entry.getKey());
                if (map == null) {
                    map = new HashMap<String, String>();
                    stateFeatures.put(entry.getKey(), map);
                }
                map.put(feature, noStart ? Constants.RequestedState.Installed.name() : Constants.RequestedState.Started.name());
            }
        }
        Map<String, Map<String, BundleInfo>> bundleInfos = resolver.getBundleInfos();
        Deployment deployment = this.computeDeployment(dstate, request, resolver);
        TreeSet<Bundle> toRefresh = new TreeSet<Bundle>(new BundleComparator());
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            toRefresh.addAll(regionDeployment.toDelete);
            toRefresh.addAll(regionDeployment.toUpdate.keySet());
        }
        if (!noRefreshManaged) {
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), deployment.resToBnd, resolver.getWiring());
        }
        if (noRefreshUnmanaged) {
            toRefresh.removeAll(MapUtils.flatten(unmanagedBundles));
        }
        TreeSet<Bundle> toManage = new TreeSet<Bundle>(new BundleComparator());
        if (!noManageBundles) {
            Set<Resource> features = resolver.getFeatures().keySet();
            Set<BundleRevision> unmanaged = MapUtils.apply(MapUtils.flatten(unmanagedBundles), this.adapt(BundleRevision.class));
            HashSet<Resource> requested = new HashSet<Resource>();
            for (List<Wire> wires : resolver.getWiring().values()) {
                for (Wire wire : wires) {
                    if (!features.contains(wire.getRequirer()) || !unmanaged.contains(wire.getProvider())) continue;
                    requested.add(wire.getProvider());
                }
            }
            unmanaged.removeAll(requested);
            for (List<Wire> wires : resolver.getWiring().values()) {
                for (Wire wire : wires) {
                    if (!requested.contains(wire.getProvider()) || !unmanaged.contains(wire.getRequirer())) continue;
                    requested.remove(wire.getProvider());
                }
            }
            if (!requested.isEmpty()) {
                long id;
                HashMap<Long, String> bundleToRegion = new HashMap<Long, String>();
                for (Map.Entry<String, Set<Object>> entry : dstate.bundlesPerRegion.entrySet()) {
                    Iterator<Object> i$ = entry.getValue().iterator();
                    while (i$.hasNext()) {
                        id = (Long)i$.next();
                        bundleToRegion.put(id, entry.getKey());
                    }
                }
                for (Resource resource : requested) {
                    Bundle bundle = ((BundleRevision)resource).getBundle();
                    id = bundle.getBundleId();
                    MapUtils.addToMapSet(managedBundles, bundleToRegion.get(id), id);
                    toManage.add(bundle);
                }
            }
        }
        HashSet<Bundle> toStart = new HashSet<Bundle>();
        HashSet<Bundle> toResolve = new HashSet<Bundle>();
        HashSet<Object> toStop = new HashSet<Bundle>();
        HashMap<Resource, Constants.RequestedState> states = new HashMap<Resource, Constants.RequestedState>();
        for (Map.Entry<String, Set<Resource>> entry : resolver.getFeaturesPerRegions().entrySet()) {
            String region = entry.getKey();
            Map<String, String> fss = stateFeatures.get(region);
            for (Resource resource : entry.getValue()) {
                String string = fss.get(ResourceUtils.getFeatureId(resource));
                this.propagateState(states, resource, Constants.RequestedState.valueOf(string), resolver);
            }
        }
        states.keySet().retainAll(resolver.getBundles().keySet());
        for (Map.Entry<String, Set<Object>> entry : states.entrySet()) {
            Bundle bundle2 = deployment.resToBnd.get(entry.getKey());
            if (bundle2 == null) continue;
            switch ((Constants.RequestedState)((Object)entry.getValue())) {
                case Started: {
                    toResolve.add(bundle2);
                    toStart.add(bundle2);
                    break;
                }
                case Resolved: {
                    toResolve.add(bundle2);
                    toStop.add(bundle2);
                }
            }
        }
        HashMap<Resource, Integer> startLevels = new HashMap<Resource, Integer>();
        HashMap<Bundle, Integer> hashMap = new HashMap<Bundle, Integer>();
        for (Map.Entry<String, Set<Resource>> entry : resolver.getBundlesPerRegions().entrySet()) {
            String region = entry.getKey();
            for (Resource resource : entry.getValue()) {
                int curSl;
                BundleInfo bundleInfo = bundleInfos.get(region).get(ResourceUtils.getUri(resource));
                if (bundleInfo == null) continue;
                int n = bundleInfo.getStartLevel() > 0 ? bundleInfo.getStartLevel() : dstate.initialBundleStartLevel;
                startLevels.put(resource, n);
                Bundle bundle6 = deployment.resToBnd.get(resource);
                if (bundle6 == null || n == (curSl = ((BundleStartLevel)bundle6.adapt(BundleStartLevel.class)).getStartLevel())) continue;
                hashMap.put(bundle6, n);
                if (n <= dstate.currentStartLevel) continue;
                toStop.add(bundle6);
            }
        }
        this.logDeployment(deployment, display);
        if (!noRefresh && !toRefresh.isEmpty()) {
            this.print("  Bundles to refresh:", display);
            for (Bundle bundle3 : toRefresh) {
                this.print("    " + bundle3.getSymbolicName() + " / " + bundle3.getVersion(), display);
            }
        }
        if (!toManage.isEmpty()) {
            this.print("  Managing bundle:", display);
            for (Bundle bundle4 : toManage) {
                this.print("    " + bundle4.getSymbolicName() + " / " + bundle4.getVersion(), display);
            }
        }
        if (simulate) {
            return;
        }
        this.callback.phase("installing");
        RegionDeployment rootRegionDeployment = deployment.regions.get("root");
        if (rootRegionDeployment != null && rootRegionDeployment.toDelete.contains(dstate.serviceBundle)) {
            throw new UnsupportedOperationException("Uninstalling the agent bundle is not supported");
        }
        if (toRefresh.contains(dstate.serviceBundle)) {
            OsgiUtils.ensureAllClassesLoaded(dstate.serviceBundle);
        }
        if (rootRegionDeployment != null && rootRegionDeployment.toUpdate.containsKey(dstate.serviceBundle)) {
            this.callback.phase("updating agent");
            this.callback.persistResolveRequest(request);
            if (deployment.bundleChecksums.containsKey(dstate.serviceBundle.getBundleId())) {
                State state = dstate.state.copy();
                state.bundleChecksums.put(dstate.serviceBundle.getBundleId(), deployment.bundleChecksums.get(dstate.serviceBundle.getBundleId()));
                this.callback.saveState(state);
            }
            Resource resource2 = rootRegionDeployment.toUpdate.get(dstate.serviceBundle);
            String uri = ResourceUtils.getUri(resource2);
            this.print("The agent bundle needs is being updated with " + uri, display);
            toRefresh.clear();
            toRefresh.add(dstate.serviceBundle);
            this.computeBundlesToRefresh(toRefresh, dstate.bundles.values(), Collections.emptyMap(), Collections.emptyMap());
            this.callback.stopBundle(dstate.serviceBundle, 1);
            Throwable throwable = null;
            try (InputStream inputStream = this.getBundleInputStream(resource2, providers);){
                this.callback.updateBundle(dstate.serviceBundle, inputStream);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.callback.refreshPackages(toRefresh);
            this.callback.startBundle(dstate.serviceBundle);
            return;
        }
        if (!newFeatures.isEmpty()) {
            Set<Feature> set = MapUtils.apply(MapUtils.flatten(newFeatures), MapUtils.map(dstate.features));
            for (Feature feature : set) {
                Downloader downloader = this.manager.createDownloader();
                for (ConfigFile configFile : feature.getConfigurationFiles()) {
                    downloader.download(configFile.getLocation(), null);
                }
                downloader.await();
            }
        }
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            toStop.addAll(regionDeployment.toUpdate.keySet());
            toStop.addAll(regionDeployment.toDelete);
        }
        this.removeFragmentsAndBundlesInState(toStop, 21);
        if (!toStop.isEmpty()) {
            this.callback.phase("updating (stopping bundles)");
            this.print("Stopping bundles:", display);
            while (!toStop.isEmpty()) {
                List<Bundle> bs = this.getBundlesToStop(toStop);
                for (Bundle bundle : bs) {
                    this.print("  " + bundle.getSymbolicName() + " / " + bundle.getVersion(), display);
                    this.callback.stopBundle(bundle, hashMap.containsKey(bundle) ? 0 : 1);
                    toStop.remove(bundle);
                }
            }
        }
        boolean hasToDelete = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            hasToDelete = !regionDeployment.toDelete.isEmpty();
            if (!hasToDelete) continue;
            break;
        }
        if (hasToDelete) {
            this.callback.phase("updating (uninstalling bundles)");
            this.print("Uninstalling bundles:", display);
            for (Map.Entry entry : deployment.regions.entrySet()) {
                String string = (String)entry.getKey();
                RegionDeployment regionDeployment = (RegionDeployment)entry.getValue();
                for (Bundle bundle : regionDeployment.toDelete) {
                    this.print("  " + bundle.getSymbolicName() + " / " + bundle.getVersion(), display);
                    this.callback.uninstall(bundle);
                    MapUtils.removeFromMapSet(managedBundles, string, bundle.getBundleId());
                }
            }
        }
        HashMap<String, Set<Long>> bundles = new HashMap<String, Set<Long>>();
        MapUtils.add(bundles, MapUtils.apply(unmanagedBundles, this.bundleId()));
        MapUtils.add(bundles, managedBundles);
        RegionDigraph regionDigraph = resolver.getFlatDigraph();
        Map<String, Map<String, Map<String, Set<String>>>> map = MapUtils.copy(dstate.filtersPerRegion);
        map.keySet().retainAll(bundles.keySet());
        for (String string : map.keySet()) {
            map.get(string).keySet().retainAll(map.keySet());
        }
        for (Region region : regionDigraph.getRegions()) {
            String name = region.getName();
            Map<String, Map<String, Set<String>>> policy = map.get(name);
            if (policy == null) {
                policy = new HashMap<String, Map<String, Set<String>>>();
                map.put(name, policy);
            }
            for (RegionDigraph.FilteredRegion fr : region.getEdges()) {
                r2 = fr.getRegion().getName();
                HashMap filters = new HashMap();
                Map<String, Collection<String>> current = fr.getFilter().getSharingPolicy();
                for (String ns : current.keySet()) {
                    for (String f : current.get(ns)) {
                        MapUtils.addToMapSet(filters, ns, f);
                    }
                }
                policy.put((String)r2, filters);
            }
        }
        this.callback.replaceDigraph(map, bundles);
        boolean hasToUpdate = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            hasToUpdate = !regionDeployment.toUpdate.isEmpty();
            if (!hasToUpdate) continue;
            break;
        }
        if (hasToUpdate) {
            this.callback.phase("updating (updating bundles)");
            this.print("Updating bundles:", display);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                for (Map.Entry<Bundle, Resource> entry2 : entry.getValue().toUpdate.entrySet()) {
                    Bundle bundle;
                    bundle = entry2.getKey();
                    Resource resource = entry2.getValue();
                    String uri = ResourceUtils.getUri(resource);
                    this.print("  " + uri, display);
                    InputStream is = this.getBundleInputStream(resource, providers);
                    r2 = null;
                    try {
                        this.callback.updateBundle(bundle, is);
                    }
                    catch (Throwable x2) {
                        r2 = x2;
                        throw x2;
                    }
                    finally {
                        if (is != null) {
                            if (r2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)r2).addSuppressed(x2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    toStart.add(bundle);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Bundle bundle = (Bundle)entry.getKey();
            int n = (Integer)entry.getValue();
            this.callback.setBundleStartLevel(bundle, n);
        }
        boolean bl2 = false;
        for (RegionDeployment regionDeployment : deployment.regions.values()) {
            bl = !regionDeployment.toInstall.isEmpty();
            if (!bl) continue;
            break;
        }
        if (bl) {
            this.callback.phase("updating (installing bundles)");
            this.print("Installing bundles:", display);
            for (Map.Entry<String, RegionDeployment> entry : deployment.regions.entrySet()) {
                String string = entry.getKey();
                RegionDeployment regionDeployment = entry.getValue();
                for (Resource resource : regionDeployment.toInstall) {
                    Constants.RequestedState reqState;
                    int startLevel;
                    long crc;
                    Bundle bundle8;
                    String uri = ResourceUtils.getUri(resource);
                    this.print("  " + uri, display);
                    try (ChecksumUtils.CRCInputStream is = new ChecksumUtils.CRCInputStream(this.getBundleInputStream(resource, providers));){
                        bundle8 = this.callback.installBundle(string, uri, is);
                        crc = is.getCRC();
                    }
                    MapUtils.addToMapSet(managedBundles, string, bundle8.getBundleId());
                    deployment.resToBnd.put(resource, bundle8);
                    if ("crc".equals(request.updateSnaphots) && this.isUpdateable(resource) && !deployment.bundleChecksums.containsKey(bundle8.getBundleId())) {
                        deployment.bundleChecksums.put(bundle8.getBundleId(), crc);
                    }
                    if (startLevels.containsKey(resource) && (startLevel = ((Integer)startLevels.get(resource)).intValue()) != dstate.initialBundleStartLevel) {
                        this.callback.setBundleStartLevel(bundle8, startLevel);
                    }
                    if ((reqState = (Constants.RequestedState)((Object)states.get(resource))) == null) {
                        reqState = Constants.RequestedState.Started;
                    }
                    switch (reqState) {
                        case Started: {
                            toResolve.add(bundle8);
                            toStart.add(bundle8);
                            break;
                        }
                        case Resolved: {
                            toResolve.add(bundle8);
                        }
                    }
                }
            }
        }
        State state = new State();
        state.bundleChecksums.putAll(deployment.bundleChecksums);
        state.requirements.putAll(request.requirements);
        state.installedFeatures.putAll(installedFeatures);
        state.stateFeatures.putAll(stateFeatures);
        state.managedBundles.putAll(managedBundles);
        this.callback.saveState(state);
        if (!newFeatures.isEmpty()) {
            this.callback.phase("updating (installing configurations)");
            Set<Feature> set = MapUtils.apply(MapUtils.flatten(newFeatures), MapUtils.map(dstate.features));
            for (Feature feature : set) {
                this.callback.installFeatureConfigs(feature);
            }
        }
        this.callback.phase("finalizing");
        if (!noRefresh) {
            toStop = new HashSet();
            toStop.addAll(toRefresh);
            this.removeFragmentsAndBundlesInState(toStop, 21);
            if (!toStop.isEmpty()) {
                this.callback.phase("finalizing (stopping bundles)");
                this.print("Stopping bundles:", display);
                while (!toStop.isEmpty()) {
                    List<Bundle> list = this.getBundlesToStop(toStop);
                    for (Bundle bundle : list) {
                        this.print("  " + bundle.getSymbolicName() + " / " + bundle.getVersion(), display);
                        this.callback.stopBundle(bundle, 1);
                        toStop.remove(bundle);
                        toStart.add(bundle);
                    }
                }
            }
            if (!toRefresh.isEmpty()) {
                this.callback.phase("finalizing (refreshing bundles)");
                this.print("Refreshing bundles:", display);
                for (Bundle bundle : toRefresh) {
                    this.print("  " + bundle.getSymbolicName() + " / " + bundle.getVersion(), display);
                }
                if (!toRefresh.isEmpty()) {
                    this.callback.refreshPackages(toRefresh);
                }
            }
        }
        this.callback.phase("finalizing (resolving bundles)");
        toResolve.addAll(toStart);
        toResolve.addAll(toRefresh);
        this.removeFragmentsAndBundlesInState(toResolve, 1);
        this.callback.resolveBundles(toResolve, resolver.getWiring(), deployment.resToBnd);
        this.removeFragmentsAndBundlesInState(toStart, 41);
        if (!toStart.isEmpty()) {
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            this.callback.phase("finalizing (starting bundles)");
            this.print("Starting bundles:", display);
            while (!toStart.isEmpty()) {
                List<Bundle> list = this.getBundlesToStart(toStart, dstate.serviceBundle);
                for (Bundle bundle10 : list) {
                    this.print("  " + bundle10.getSymbolicName() + " / " + bundle10.getVersion(), display);
                    try {
                        this.callback.startBundle(bundle10);
                    }
                    catch (BundleException e) {
                        arrayList.add(e);
                    }
                    toStart.remove(bundle10);
                }
            }
            if (!arrayList.isEmpty()) {
                throw new MultiException("Error restarting bundles", arrayList);
            }
        }
        this.print("Done.", display);
    }

    private void propagateState(Map<Resource, Constants.RequestedState> states, Resource resource, Constants.RequestedState state, SubsystemResolver resolver) {
        Constants.RequestedState reqState;
        if (!this.isSubsystem(resource) && (reqState = this.mergeStates(state, states.get(resource))) != states.get(resource)) {
            states.put(resource, reqState);
            for (Wire wire : resolver.getWiring().get(resource)) {
                String effective;
                BundleInfo bi;
                Resource provider = wire.getProvider();
                String region = resolver.getBundles().get(provider);
                BundleInfo bundleInfo = bi = region != null ? resolver.getBundleInfos().get(region).get(ResourceUtils.getUri(provider)) : null;
                Constants.RequestedState stateToMerge = reqState == Constants.RequestedState.Started ? (("active".equals(effective = (String)wire.getCapability().getDirectives().get("effective")) || "osgi.identity".equals(wire.getCapability().getNamespace())) && (bi == null || bi.isStart()) ? Constants.RequestedState.Started : Constants.RequestedState.Resolved) : reqState;
                this.propagateState(states, provider, stateToMerge, resolver);
            }
        }
    }

    private boolean isSubsystem(Resource resource) {
        return "karaf.subsystem".equals(ResourceUtils.getType(resource));
    }

    private boolean isBundle(Resource resource) {
        return "osgi.bundle".equals(ResourceUtils.getType(resource));
    }

    private Constants.RequestedState mergeStates(Constants.RequestedState s1, Constants.RequestedState s2) {
        if (s1 == Constants.RequestedState.Started || s2 == Constants.RequestedState.Started) {
            return Constants.RequestedState.Started;
        }
        if (s1 == Constants.RequestedState.Resolved || s2 == Constants.RequestedState.Resolved) {
            return Constants.RequestedState.Resolved;
        }
        return Constants.RequestedState.Installed;
    }

    private void computeBundlesToRefresh(Set<Bundle> toRefresh, Collection<Bundle> bundles, Map<Resource, Bundle> resources, Map<Resource, List<Wire>> resolution) {
        int size;
        HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
        for (Map.Entry<Resource, Bundle> entry : resources.entrySet()) {
            bndToRes.put(entry.getValue(), entry.getKey());
        }
        do {
            size = toRefresh.size();
            block2: for (Bundle bundle : bundles) {
                List<Wire> newWires;
                BundleWiring wiring;
                Resource resource = (Resource)bndToRes.get(bundle);
                if (resource == null || toRefresh.contains(bundle) || (wiring = (BundleWiring)bundle.adapt(BundleWiring.class)) == null || (newWires = resolution.get(resource)) == null) continue;
                HashSet<Resource> wiredBundles = new HashSet<Resource>();
                for (BundleWire wire : wiring.getRequiredWires(null)) {
                    BundleRevision rev = wire.getProvider();
                    Bundle b = rev.getBundle();
                    if (toRefresh.contains(b)) {
                        LOGGER.info("Refreshing " + bundle.getSymbolicName() + " / " + bundle.getVersion() + " because it's wired to " + b.getSymbolicName() + "/" + b.getVersion() + " which is being refreshed (through" + wire.getRequirement() + ")");
                        toRefresh.add(bundle);
                        continue block2;
                    }
                    Resource res = (Resource)bndToRes.get(b);
                    wiredBundles.add((Resource)(res != null ? res : rev));
                }
                HashMap<Resource, Requirement> wiredResources = new HashMap<Resource, Requirement>();
                for (Wire wire : newWires) {
                    String effective;
                    String namespace = wire.getRequirement().getNamespace();
                    if (!namespace.equals("osgi.wiring.bundle") && !namespace.equals("osgi.wiring.package") && !namespace.equals("osgi.wiring.host") || (effective = (String)wire.getRequirement().getDirectives().get("effective")) != null && !"resolve".equals(effective) || !this.isBundle(wire.getProvider()) || wiredResources.containsKey(wire.getProvider())) continue;
                    wiredResources.put(wire.getProvider(), wire.getRequirement());
                }
                if (wiredBundles.containsAll(wiredResources.keySet())) continue;
                HashMap newResources = new HashMap(wiredResources);
                newResources.keySet().removeAll(wiredBundles);
                StringBuilder sb = new StringBuilder();
                sb.append("Refreshing ").append(bundle.getSymbolicName()).append(" / ").append(bundle.getVersion()).append(" because it should be wired to: ");
                boolean first = true;
                for (Map.Entry entry : newResources.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    Resource res = (Resource)entry.getKey();
                    Requirement req = (Requirement)entry.getValue();
                    sb.append(ResourceUtils.getSymbolicName(res)).append("/").append(ResourceUtils.getVersion(res));
                    sb.append(" (through ");
                    sb.append(req);
                    sb.append(")");
                }
                LOGGER.info(sb.toString());
                toRefresh.add(bundle);
            }
        } while (toRefresh.size() > size);
    }

    private void print(String message, int verbose) {
        this.callback.print(message, verbose);
    }

    private void removeFragmentsAndBundlesInState(Collection<Bundle> bundles, int state) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if ((bundle.getState() & state) == 0 && bundle.getHeaders().get("Fragment-Host") == null) continue;
            iterator.remove();
        }
    }

    protected void logDeployment(Deployment overallDeployment, int verbose) {
        if (overallDeployment.regions.isEmpty()) {
            this.print("No deployment change.", verbose);
            return;
        }
        this.print("Changes to perform:", verbose);
        for (Map.Entry<String, RegionDeployment> region : overallDeployment.regions.entrySet()) {
            RegionDeployment deployment = region.getValue();
            this.print("  Region: " + region.getKey(), verbose);
            if (!deployment.toDelete.isEmpty()) {
                this.print("    Bundles to uninstall:", verbose);
                for (Bundle bundle : deployment.toDelete) {
                    this.print("      " + bundle.getSymbolicName() + " / " + bundle.getVersion(), verbose);
                }
            }
            if (!deployment.toUpdate.isEmpty()) {
                this.print("    Bundles to update:", verbose);
                for (Map.Entry entry : deployment.toUpdate.entrySet()) {
                    this.print("      " + ((Bundle)entry.getKey()).getSymbolicName() + " / " + ((Bundle)entry.getKey()).getVersion() + " with " + ResourceUtils.getUri((Resource)entry.getValue()), verbose);
                }
            }
            if (deployment.toInstall.isEmpty()) continue;
            this.print("    Bundles to install:", verbose);
            for (Resource resource : deployment.toInstall) {
                this.print("      " + ResourceUtils.getUri(resource), verbose);
            }
        }
    }

    protected Deployment computeDeployment(DeploymentState dstate, DeploymentRequest request, SubsystemResolver resolver) throws IOException {
        Deployment result = new Deployment();
        Map<String, Set<Resource>> bundlesPerRegions = resolver.getBundlesPerRegions();
        HashSet<String> regions = new HashSet<String>();
        regions.addAll(dstate.state.managedBundles.keySet());
        regions.addAll(bundlesPerRegions.keySet());
        for (String region : regions) {
            Set<Resource> bundlesInRegion;
            RegionDeployment deployment = new RegionDeployment();
            Set<Long> managed = dstate.state.managedBundles.get(region);
            if (managed == null) {
                managed = Collections.emptySet();
            }
            ArrayList<Resource> toDeploy = (bundlesInRegion = bundlesPerRegions.get(region)) != null ? new ArrayList<Resource>(bundlesInRegion) : new ArrayList();
            for (long bundleId : managed) {
                Bundle bundle = dstate.bundles.get(bundleId);
                if (bundle == null) continue;
                Resource resource = null;
                for (Resource res : toDeploy) {
                    if (!bundle.getSymbolicName().equals(ResourceUtils.getSymbolicName(res)) || !bundle.getVersion().equals((Object)ResourceUtils.getVersion(res))) continue;
                    resource = res;
                    break;
                }
                if (resource != null) {
                    if (this.isUpdateable(resource)) {
                        if ("always".equalsIgnoreCase(request.updateSnaphots)) {
                            LOGGER.debug("Update snapshot for " + bundle.getLocation());
                            deployment.toUpdate.put(bundle, resource);
                        } else if ("crc".equalsIgnoreCase(request.updateSnaphots)) {
                            try (InputStream is = this.getBundleInputStream(resource, resolver.getProviders());){
                                long oldCrc;
                                long newCrc = ChecksumUtils.checksum(is);
                                long l = oldCrc = dstate.state.bundleChecksums.containsKey(bundle.getBundleId()) ? dstate.state.bundleChecksums.get(bundle.getBundleId()) : 0L;
                                if (newCrc != oldCrc) {
                                    LOGGER.debug("New snapshot available for " + bundle.getLocation());
                                    deployment.toUpdate.put(bundle, resource);
                                }
                                result.bundleChecksums.put(bundle.getBundleId(), newCrc);
                            }
                        }
                    }
                    toDeploy.remove(resource);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                if (!managed.contains(bundle.getBundleId())) continue;
                deployment.toDelete.add(bundle);
            }
            for (Resource resource : toDeploy) {
                TreeMap<Version, Bundle> matching = new TreeMap<Version, Bundle>();
                VersionRange range = new VersionRange(Macro.transform(request.bundleUpdateRange, ResourceUtils.getVersion(resource).toString()));
                for (Bundle bundle : deployment.toDelete) {
                    if (!bundle.getSymbolicName().equals(ResourceUtils.getSymbolicName(resource)) || !range.contains(bundle.getVersion())) continue;
                    matching.put(bundle.getVersion(), bundle);
                }
                if (!matching.isEmpty()) {
                    Bundle bundle = (Bundle)matching.lastEntry().getValue();
                    deployment.toUpdate.put(bundle, resource);
                    deployment.toDelete.remove(bundle);
                    result.resToBnd.put(resource, bundle);
                    continue;
                }
                deployment.toInstall.add(resource);
            }
            Collections.sort(deployment.toInstall, new ResourceComparator());
            if (deployment.toDelete.isEmpty() && deployment.toUpdate.isEmpty() && deployment.toInstall.isEmpty()) continue;
            result.regions.put(region, deployment);
        }
        return result;
    }

    protected <T> MapUtils.Function<Bundle, T> adapt(final Class<T> clazz) {
        return new MapUtils.Function<Bundle, T>(){

            @Override
            public T apply(Bundle bundle) {
                return bundle.adapt(clazz);
            }
        };
    }

    protected MapUtils.Function<Bundle, Long> bundleId() {
        return new MapUtils.Function<Bundle, Long>(){

            @Override
            public Long apply(Bundle bundle) {
                return bundle.getBundleId();
            }
        };
    }

    protected MapUtils.Function<Resource, String> featureId() {
        return new MapUtils.Function<Resource, String>(){

            @Override
            public String apply(Resource resource) {
                return ResourceUtils.getFeatureId(resource);
            }
        };
    }

    protected boolean isUpdateable(Resource resource) {
        String uri = ResourceUtils.getUri(resource);
        return uri.matches("mvn:.*-SNAPSHOT((\\.\\w{3})?|\\$.*|\\?.*|\\#.*|\\&.*)|(?!mvn:).*");
    }

    protected List<Bundle> getBundlesToStart(Collection<Bundle> bundles, Bundle serviceBundle) {
        boolean restart = false;
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Bundle bundle : bundles) {
            if (bundle == serviceBundle) {
                restart = true;
                continue;
            }
            int n = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, n, bundle);
        }
        bundles = bundlesPerStartLevel.isEmpty() ? Collections.emptyList() : (Collection<Object>)bundlesPerStartLevel.remove(bundlesPerStartLevel.firstKey());
        ArrayList<Object> revs = new ArrayList<Object>();
        for (Bundle bundle : bundles) {
            revs.add(bundle.adapt(BundleRevision.class));
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (BundleRevision rev : RequirementSort.sort(revs)) {
            arrayList.add(rev.getBundle());
        }
        if (arrayList.isEmpty() && restart) {
            arrayList.add(serviceBundle);
        }
        return arrayList;
    }

    protected List<Bundle> getBundlesToStop(Collection<Bundle> bundles) {
        TreeMap bundlesPerStartLevel = new TreeMap();
        for (Bundle bundle : bundles) {
            int sl = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            MapUtils.addToMapSet(bundlesPerStartLevel, sl, bundle);
        }
        bundles = (Collection)bundlesPerStartLevel.get(bundlesPerStartLevel.lastKey());
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += Deployer.getServiceUsage(reference, bundles);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (Deployer.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, Collection<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    protected InputStream getBundleInputStream(Resource resource, Map<String, StreamProvider> providers) throws IOException {
        String uri = ResourceUtils.getUri(resource);
        if (uri == null) {
            throw new IllegalStateException("Resource has no uri");
        }
        StreamProvider provider = providers.get(uri);
        if (provider == null) {
            throw new IllegalStateException("Resource " + uri + " has no StreamProvider");
        }
        return new FileInputStream(provider.getFile());
    }

    static class RegionDeployment {
        List<Resource> toInstall = new ArrayList<Resource>();
        List<Bundle> toDelete = new ArrayList<Bundle>();
        Map<Bundle, Resource> toUpdate = new HashMap<Bundle, Resource>();

        RegionDeployment() {
        }
    }

    static class Deployment {
        Map<Long, Long> bundleChecksums = new HashMap<Long, Long>();
        Map<Resource, Bundle> resToBnd = new HashMap<Resource, Bundle>();
        Map<String, RegionDeployment> regions = new HashMap<String, RegionDeployment>();

        Deployment() {
        }
    }

    static class DeploymentRequest {
        Set<String> overrides;
        String featureResolutionRange;
        String bundleUpdateRange;
        String updateSnaphots;
        Repository globalRepository;
        Map<String, Map<VersionRange, Map<String, String>>> metadata;
        Map<String, Set<String>> requirements;
        Map<String, Map<String, Constants.RequestedState>> stateChanges;
        EnumSet<Constants.Option> options;

        DeploymentRequest() {
        }
    }

    static class DeploymentState {
        State state;
        Bundle serviceBundle;
        int initialBundleStartLevel;
        int currentStartLevel;
        Map<Long, Bundle> bundles;
        Map<String, Feature> features;
        Map<String, Set<Long>> bundlesPerRegion;
        Map<String, Map<String, Map<String, Set<String>>>> filtersPerRegion;

        DeploymentState() {
        }
    }

    public static class PartialDeploymentException
    extends Exception {
        private final Set<String> missing;

        public PartialDeploymentException(Set<String> missing) {
            this.missing = missing;
        }

        public Set<String> getMissing() {
            return this.missing;
        }
    }

    public static interface DeployCallback {
        public void phase(String var1);

        public void print(String var1, int var2);

        public void saveState(State var1);

        public void persistResolveRequest(DeploymentRequest var1) throws IOException;

        public void installFeatureConfigs(Feature var1) throws IOException, InvalidSyntaxException;

        public Bundle installBundle(String var1, String var2, InputStream var3) throws BundleException;

        public void updateBundle(Bundle var1, InputStream var2) throws BundleException;

        public void uninstall(Bundle var1) throws BundleException;

        public void startBundle(Bundle var1) throws BundleException;

        public void stopBundle(Bundle var1, int var2) throws BundleException;

        public void setBundleStartLevel(Bundle var1, int var2);

        public void refreshPackages(Collection<Bundle> var1) throws InterruptedException;

        public void resolveBundles(Set<Bundle> var1, Map<Resource, List<Wire>> var2, Map<Resource, Bundle> var3);

        public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> var1, Map<String, Set<Long>> var2) throws BundleException, InvalidSyntaxException;
    }
}

