/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.ssh;

import io.fabric8.api.AutoScaleRequest;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.HostScalingRequirements;
import io.fabric8.api.NameValidator;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.SshHostConfiguration;
import io.fabric8.api.SshScalingRequirements;
import io.fabric8.internal.autoscale.AutoScalers;
import io.fabric8.internal.autoscale.HostProfileCounter;
import io.fabric8.internal.autoscale.LoadSortedHostConfiguration;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import io.fabric8.service.ssh.SshContainerProvider;
import java.util.List;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAutoScaler
implements ContainerAutoScaler {
    private static final transient Logger LOG = LoggerFactory.getLogger(SshAutoScaler.class);
    private final SshContainerProvider containerProvider;

    public SshAutoScaler(SshContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    public int getWeight() {
        return 50;
    }

    public void createContainers(AutoScaleRequest request) throws Exception {
        int count = request.getDelta();
        String profile = request.getProfile();
        String version = request.getVersion();
        FabricService fabricService = request.getFabricService();
        Container[] containers = fabricService.getContainers();
        FabricRequirements requirements = request.getFabricRequirements();
        List hostConfigurations = requirements.getSshHosts();
        HostProfileCounter hostProfileCounter = new HostProfileCounter();
        AutoScalers.createHostToProfileScaleMap((HostProfileCounter)hostProfileCounter, (List)hostConfigurations, (Container[])containers);
        for (int i = 0; i < count; ++i) {
            CreateSshContainerOptions.Builder builder = null;
            NameValidator nameValidator = Containers.createNameValidator((Container[])containers);
            String name = Containers.createContainerName((Container[])containers, (String)profile, (String)this.containerProvider.getScheme(), (NameValidator)nameValidator);
            if (fabricService != null) {
                builder = this.createAutoScaleOptions(request, fabricService, hostProfileCounter);
            }
            if (builder == null) continue;
            CreateSshContainerOptions.Builder configuredBuilder = (CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)builder.number(1)).version(version)).profiles(profile);
            CreateSshContainerOptions options = ((CreateSshContainerOptions.Builder)configuredBuilder.name(name)).build();
            LOG.info("Creating container name " + name + " version " + version + " profile " + profile + " " + count + " container(s)");
            fabricService.createContainers((CreateContainerOptions)options);
        }
    }

    protected CreateSshContainerOptions.Builder createAutoScaleOptions(AutoScaleRequest request, FabricService fabricService, HostProfileCounter hostProfileCounter) {
        CreateSshContainerOptions.Builder builder = SshAutoScaler.chooseHostContainerOptions(request, hostProfileCounter);
        if (builder == null) {
            return null;
        }
        String zookeeperUrl = fabricService.getZookeeperUrl();
        String zookeeperPassword = fabricService.getZookeeperPassword();
        if (builder.getProxyUri() == null) {
            builder.proxyUri(fabricService.getMavenRepoURI());
        }
        return (CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)builder.zookeeperUrl(zookeeperUrl)).zookeeperPassword(zookeeperPassword);
    }

    public static CreateSshContainerOptions.Builder chooseHostContainerOptions(AutoScaleRequest request, HostProfileCounter hostProfileCounter) {
        CreateSshContainerOptions.Builder builder = CreateSshContainerOptions.builder();
        FabricRequirements requirements = request.getFabricRequirements();
        ProfileRequirements profileRequirements = request.getProfileRequirements();
        SshScalingRequirements sshScalingRequirements = profileRequirements.getSshScalingRequirements();
        List hosts = requirements.getSshHosts();
        SortedSet sortedHostConfigurations = AutoScalers.filterHosts((ProfileRequirements)profileRequirements, (HostScalingRequirements)sshScalingRequirements, (HostProfileCounter)hostProfileCounter, (List)hosts);
        SshHostConfiguration sshHostConfig = null;
        if (!sortedHostConfigurations.isEmpty()) {
            LoadSortedHostConfiguration first = (LoadSortedHostConfiguration)sortedHostConfigurations.first();
            sshHostConfig = (SshHostConfiguration)first.getConfiguration();
        }
        if (sshHostConfig == null) {
            LOG.warn("Could not create version " + request.getVersion() + " profile " + request.getProfile() + " as no matching hosts could be found for " + sshScalingRequirements);
            request.getProfileAutoScaleStatus().noSuitableHost("" + sshScalingRequirements);
            return null;
        }
        builder.configure(sshHostConfig, requirements, profileRequirements);
        return builder;
    }

    public void destroyContainers(String profile, int count, List<Container> containers) {
    }
}

