/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.FabricRequirements;
import io.fabric8.internal.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequirementsJson {
    private static final transient Logger LOG = LoggerFactory.getLogger(RequirementsJson.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private RequirementsJson() {
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void writeRequirements(OutputStream out, FabricRequirements value) throws IOException {
        mapper.writeValue(out, (Object)value);
    }

    public static String toJSON(FabricRequirements value) throws IOException {
        return RequirementsJson.valueToJSON(value);
    }

    public static String toJSON(AutoScaleStatus value) throws IOException {
        return RequirementsJson.valueToJSON(value);
    }

    protected static String valueToJSON(Object value) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, value);
            return writer.toString();
        }
        catch (IOException e) {
            LOG.warn("Failed to marshal to JSON: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public static FabricRequirements readRequirements(InputStream in) throws IOException {
        return (FabricRequirements)mapper.readValue(in, FabricRequirements.class);
    }

    public static AutoScaleStatus readAutoScaleStatus(InputStream in) throws IOException {
        return (AutoScaleStatus)mapper.readValue(in, AutoScaleStatus.class);
    }

    public static FabricRequirements fromJSON(String json) throws IOException {
        return RequirementsJson.valueFromJSON(json, FabricRequirements.class);
    }

    public static AutoScaleStatus autoScaleStatusFromJSON(String json) throws IOException {
        return RequirementsJson.valueFromJSON(json, AutoScaleStatus.class);
    }

    protected static <T> T valueFromJSON(String json, Class<T> clazz) throws IOException {
        if (json == null) {
            return null;
        }
        String trimmedJson = json.trim();
        if (trimmedJson.length() == 0 || trimmedJson.equals("{}")) {
            return null;
        }
        return (T)mapper.reader(clazz).readValue(trimmedJson);
    }

    public static boolean equal(FabricRequirements a, FabricRequirements b) throws IOException {
        String json1 = RequirementsJson.toJSON(a);
        String json2 = RequirementsJson.toJSON(b);
        return Objects.equal(json1, json2);
    }

    static {
        mapper.getSerializationConfig().withSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

