/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.ValidationSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@ThreadSafe
@Component(name="io.fabric8.mvel.urlhandler", label="Fabric8 MVEL URL Handler", immediate=true, metatype=false)
@Service(value={URLStreamHandlerService.class})
@Properties(value={@Property(name="url.handler.protocol", value={"mvel"})})
public final class MvelUrlHandler
extends AbstractURLStreamHandlerService
implements Validatable {
    protected static final String SCHEME = "mvel";
    private static final String SYNTAX = "mvel:<resource name>";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    private final ValidationSupport active = new ValidationSupport();

    @Activate
    void activate() {
        this.active.setValid();
    }

    @Deactivate
    void deactivate() {
        this.active.setInvalid();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    public URLConnection openConnection(URL url) throws IOException {
        this.assertValid();
        return new Connection(url);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    private class Connection
    extends URLConnection {
        public Connection(URL url) throws MalformedURLException {
            super(url);
            if (url.getPath() == null || url.getPath().trim().length() == 0) {
                throw new MalformedURLException("Path can not be null or empty. Syntax: mvel:<resource name>");
            }
            if (url.getHost() != null && url.getHost().length() > 0 || url.getPort() != -1) {
                throw new MalformedURLException("Unsupported host/port in mvel url");
            }
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                throw new MalformedURLException("Unsupported query in mvel url");
            }
        }

        @Override
        public void connect() throws IOException {
            MvelUrlHandler.this.assertValid();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            MvelUrlHandler.this.assertValid();
            String path = this.url.getPath();
            URL url = new URL(path);
            CompiledTemplate compiledTemplate = TemplateCompiler.compileTemplate((InputStream)url.openStream());
            HashMap<String, Object> data = new HashMap<String, Object>();
            Profile overlayProfile = ((FabricService)MvelUrlHandler.this.fabricService.get()).getCurrentContainer().getOverlayProfile();
            data.put("profile", Profiles.getEffectiveProfile((FabricService)((FabricService)MvelUrlHandler.this.fabricService.get()), (Profile)overlayProfile));
            data.put("runtime", MvelUrlHandler.this.runtimeProperties.get());
            String content = TemplateRuntime.execute((CompiledTemplate)compiledTemplate, data).toString();
            return new ByteArrayInputStream(content.getBytes());
        }
    }
}

