/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.gravia.IllegalArgumentAssertion;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.ObjectUtils;
import io.fabric8.common.util.Strings;
import io.fabric8.internal.RequirementsJson;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.FabricVersionUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(label="Fabric8 DataStore", policy=ConfigurationPolicy.IGNORE, immediate=true, metatype=true)
@Service(value={DataStore.class})
public final class ZkDataStoreImpl
extends AbstractComponent
implements DataStore,
PathChildrenCacheListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ZkDataStoreImpl.class);
    private static final String JVM_OPTIONS_PATH = "/fabric/configs/io.fabric8.containers.jvmOptions";
    private static final String REQUIREMENTS_JSON_PATH = "/fabric/configs/io.fabric8.requirements.json";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    private final CopyOnWriteArrayList<Runnable> callbacks = new CopyOnWriteArrayList();
    private final ExecutorService cacheExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService callbacksExecutor = Executors.newSingleThreadExecutor();
    private TreeCache configCache;
    private TreeCache containerCache;

    @Activate
    void activate() throws Exception {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    private void activateInternal() throws Exception {
        this.configCache = new TreeCache((CuratorFramework)this.curator.get(), ZkPath.CONFIGS.getPath(new String[0]), true, false, true, this.cacheExecutor);
        this.configCache.start(TreeCache.StartMode.NORMAL);
        this.configCache.getListenable().addListener((Object)this);
        this.containerCache = new TreeCache((CuratorFramework)this.curator.get(), ZkPath.CONTAINERS.getPath(new String[0]), true, false, true, this.cacheExecutor);
        this.containerCache.start(TreeCache.StartMode.NORMAL);
        this.containerCache.getListenable().addListener((Object)this);
    }

    private void deactivateInternal() {
        this.configCache.getListenable().removeListener((Object)this);
        Closeables.closeQuietly((Closeable)this.configCache);
        this.containerCache.getListenable().removeListener((Object)this);
        Closeables.closeQuietly((Closeable)this.containerCache);
        this.callbacksExecutor.shutdownNow();
        this.cacheExecutor.shutdownNow();
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (this.isValid()) {
            ChildData childData = event.getData();
            String path = childData != null ? childData.getPath() : null;
            byte[] data = null;
            if (childData != null) {
                data = childData.getData();
            }
            PathChildrenCacheEvent.Type type = event.getType();
            switch (type) {
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_UPDATED: 
                case INITIALIZED: {
                    if (!this.shouldRunCallbacks(type, path)) break;
                    String s = data != null ? new String(data, "UTF-8") : "";
                    LOGGER.info("Event {} detected on {} with data {}. Sending notification.", new Object[]{type.name(), path, s});
                    this.fireChangeNotifications();
                }
            }
        }
    }

    private boolean shouldRunCallbacks(PathChildrenCacheEvent.Type type, String path) {
        if (path == null) {
            return false;
        }
        String runtimeIdentity = ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
        String currentVersion = this.getContainerVersion(runtimeIdentity);
        return path.startsWith(ZkPath.CONTAINERS.getPath(new String[0])) && type.equals((Object)PathChildrenCacheEvent.Type.CHILD_UPDATED) || path.equals(ZkPath.CONFIG_ENSEMBLES.getPath(new String[0])) || path.equals(ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0])) || path.equals(ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0])) || path.equals(ZkPath.CONFIG_CONTAINER.getPath(new String[]{runtimeIdentity})) || currentVersion != null && path.equals(ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{currentVersion, runtimeIdentity}));
    }

    public void fireChangeNotifications() {
        this.runCallbacks();
    }

    private void runCallbacks() {
        this.callbacksExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ZkDataStoreImpl.this.doRunCallbacks();
            }
        });
    }

    private void doRunCallbacks() {
        this.assertValid();
        for (Runnable callback : this.callbacks) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Running callback " + callback);
                }
                callback.run();
            }
            catch (Throwable e) {
                LOGGER.warn("Caught: " + e, e);
            }
        }
    }

    public String getFabricReleaseVersion() {
        return FabricVersionUtils.getReleaseVersion();
    }

    public void trackConfiguration(Runnable callback) {
        if (this.isValid()) {
            this.callbacks.addIfAbsent(callback);
        }
    }

    public void untrackConfiguration(Runnable callback) {
        this.callbacks.remove(callback);
    }

    public List<String> getContainers() {
        this.assertValid();
        try {
            return ZooKeeperUtils.getChildrenSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIGS_CONTAINERS.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean hasContainer(String containerId) {
        this.assertValid();
        return this.getContainers().contains(containerId);
    }

    public String getContainerParent(String containerId) {
        this.assertValid();
        try {
            String parentName = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PARENT.getPath(new String[]{containerId}));
            return parentName != null ? parentName.trim() : "";
        }
        catch (KeeperException.NoNodeException e) {
            return "";
        }
        catch (Throwable e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void deleteContainer(FabricService fabricService, String containerId) {
        this.assertValid();
        try {
            if (this.curator.get() == null) {
                throw new IllegalStateException("Zookeeper service not available");
            }
            ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
            for (String version : profileService.getVersions()) {
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, containerId}));
            }
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PROVISION.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_STATUS.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.AUTHENTICATION_CONTAINER.getPath(new String[]{containerId}));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void createContainerConfig(CreateContainerOptions options) {
        this.assertValid();
        try {
            String parent = options.getParent();
            String containerId = options.getName();
            String versionId = options.getVersion();
            Set profileIds = options.getProfiles();
            StringBuilder sb = new StringBuilder();
            for (String profileId : profileIds) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(profileId);
            }
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}), (String)versionId);
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)sb.toString());
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PARENT.getPath(new String[]{containerId}), (String)parent);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void createContainerConfig(CreateContainerMetadata metadata) {
        this.assertValid();
        try {
            String resolver;
            CreateContainerOptions options = metadata.getCreateOptions();
            String containerId = metadata.getContainerName();
            this.setContainerMetadata(metadata);
            Map configuration = metadata.getContainerConfiguration();
            for (Map.Entry entry : configuration.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ENTRY.getPath(new String[]{metadata.getContainerName(), key}), (String)value);
            }
            String string = resolver = metadata.getOverridenResolver() != null ? metadata.getOverridenResolver() : options.getResolver();
            if (resolver == null && ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId})) != null) {
                resolver = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}));
            } else if (options.getResolver() == null) {
                resolver = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null ? ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) : "localhostname";
            }
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}), (String)resolver);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public CreateContainerMetadata getContainerMetadata(String containerId, final ClassLoader classLoader) {
        this.assertValid();
        try {
            byte[] encoded = ZooKeeperUtils.getByteData((TreeCache)this.configCache, (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{containerId}));
            if (encoded == null) {
                return null;
            }
            byte[] decoded = Base64Encoder.decode(encoded);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decoded)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return classLoader.loadClass(desc.getName());
                }
            };
            return (CreateContainerMetadata)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvalidClassException e) {
            return null;
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerMetadata(CreateContainerMetadata metadata) {
        this.assertValid();
        try {
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{metadata.getContainerName()}), (byte[])Base64Encoder.encode(ObjectUtils.toBytes((Object)metadata)));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getContainerVersion(String containerId) {
        this.assertValid();
        try {
            return ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerVersion(String containerId, String versionId) {
        this.assertValid();
        try {
            String oldVersionId = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            String oldProfileIds = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{oldVersionId, containerId}));
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)oldProfileIds);
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}), (String)versionId);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public List<String> getContainerProfiles(String containerId) {
        this.assertValid();
        try {
            String versionId;
            String str = null;
            if (Strings.isNotBlank((String)containerId) && Strings.isNotBlank((String)(versionId = ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}))))) {
                str = ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}));
            }
            return str == null || str.isEmpty() ? Collections.emptyList() : Arrays.asList(str.trim().split(" +"));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerProfiles(String containerId, List<String> profileIds) {
        this.assertValid();
        try {
            String versionId = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            HashSet<String> idset = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            for (String profileId : profileIds) {
                IllegalArgumentAssertion.assertFalse((Boolean)idset.contains(profileId), (String)("Duplicate profile id in: " + profileIds));
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(profileId);
                idset.add(profileId);
            }
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)sb.toString());
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean isContainerAlive(String id) {
        this.assertValid();
        try {
            return ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id})) != null;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerAlive(String id, boolean flag) {
        this.assertValid();
        try {
            if (flag) {
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id}), (String)"alive");
            } else {
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id}));
            }
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getContainerAttribute(String containerId, DataStore.ContainerAttribute attribute, String def, boolean mandatory, boolean substituted) {
        this.assertValid();
        if (attribute == DataStore.ContainerAttribute.Domains) {
            try {
                List list = (List)((CuratorFramework)this.curator.get()).getChildren().forPath(ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId}));
                Collections.sort(list);
                StringBuilder sb = new StringBuilder();
                for (String l : list) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(l);
                }
                return sb.toString();
            }
            catch (Exception e) {
                return "";
            }
        }
        try {
            if (substituted) {
                return ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)this.getAttributePath(containerId, attribute));
            }
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)this.getAttributePath(containerId, attribute));
        }
        catch (KeeperException.NoNodeException e) {
            if (mandatory) {
                throw FabricException.launderThrowable((Throwable)e);
            }
            return def;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerAttribute(String containerId, DataStore.ContainerAttribute attribute, String value) {
        this.assertValid();
        if (attribute == DataStore.ContainerAttribute.Resolver) {
            try {
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{containerId}), (String)("${zk:" + containerId + "/" + value + "}"));
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}), (String)value);
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
        if (attribute == DataStore.ContainerAttribute.Domains) {
            try {
                String path;
                List<String> list = value != null ? Arrays.asList(value.split("\n")) : Collections.emptyList();
                HashSet zkSet = new HashSet(ZooKeeperUtils.getChildrenSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId})));
                for (String domain : list) {
                    path = ZkPath.CONTAINER_DOMAIN.getPath(new String[]{containerId, domain});
                    if (zkSet.remove(domain)) continue;
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)"");
                }
                for (String domain : zkSet) {
                    path = ZkPath.CONTAINER_DOMAIN.getPath(new String[]{containerId, domain});
                    ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                }
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
        try {
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)this.getAttributePath(containerId, attribute), (String)value);
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    private String getAttributePath(String containerId, DataStore.ContainerAttribute attribute) {
        switch (attribute) {
            case BlueprintStatus: {
                return ZkPath.CONTAINER_EXTENDER_STATUS.getPath(new String[]{containerId, "blueprint"});
            }
            case SpringStatus: {
                return ZkPath.CONTAINER_EXTENDER_STATUS.getPath(new String[]{containerId, "spring"});
            }
            case ProvisionStatus: {
                return ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{containerId});
            }
            case ProvisionException: {
                return ZkPath.CONTAINER_PROVISION_EXCEPTION.getPath(new String[]{containerId});
            }
            case ProvisionList: {
                return ZkPath.CONTAINER_PROVISION_LIST.getPath(new String[]{containerId});
            }
            case ProvisionChecksums: {
                return ZkPath.CONTAINER_PROVISION_CHECKSUMS.getPath(new String[]{containerId});
            }
            case DebugPort: {
                return ZkPath.CONTAINER_DEBUG_PORT.getPath(new String[]{containerId});
            }
            case Location: {
                return ZkPath.CONTAINER_LOCATION.getPath(new String[]{containerId});
            }
            case GeoLocation: {
                return ZkPath.CONTAINER_GEOLOCATION.getPath(new String[]{containerId});
            }
            case Resolver: {
                return ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId});
            }
            case Ip: {
                return ZkPath.CONTAINER_IP.getPath(new String[]{containerId});
            }
            case LocalIp: {
                return ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{containerId});
            }
            case LocalHostName: {
                return ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{containerId});
            }
            case PublicIp: {
                return ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{containerId});
            }
            case PublicHostName: {
                return ZkPath.CONTAINER_PUBLIC_HOSTNAME.getPath(new String[]{containerId});
            }
            case ManualIp: {
                return ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{containerId});
            }
            case BindAddress: {
                return ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{containerId});
            }
            case JmxUrl: {
                return ZkPath.CONTAINER_JMX.getPath(new String[]{containerId});
            }
            case JolokiaUrl: {
                return ZkPath.CONTAINER_JOLOKIA.getPath(new String[]{containerId});
            }
            case HttpUrl: {
                return ZkPath.CONTAINER_HTTP.getPath(new String[]{containerId});
            }
            case SshUrl: {
                return ZkPath.CONTAINER_SSH.getPath(new String[]{containerId});
            }
            case PortMin: {
                return ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{containerId});
            }
            case PortMax: {
                return ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{containerId});
            }
            case ProcessId: {
                return ZkPath.CONTAINER_PROCESS_ID.getPath(new String[]{containerId});
            }
            case OpenShift: {
                return ZkPath.CONTAINER_OPENSHIFT.getPath(new String[]{containerId});
            }
        }
        throw new IllegalArgumentException("Unsupported container attribute " + attribute);
    }

    public String getDefaultVersion() {
        this.assertValid();
        try {
            String version = null;
            if (this.configCache.getCurrentData(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0])) != null) {
                version = ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
            }
            if (version == null || version.isEmpty()) {
                version = "1.0";
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version);
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_VERSION.getPath(new String[]{version}), (String)null);
            }
            return version;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setDefaultVersion(String versionId) {
        this.assertValid();
        try {
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)versionId);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getDefaultJvmOptions() {
        this.assertValid();
        try {
            CuratorFramework curatorFramework = (CuratorFramework)this.curator.get();
            if (curatorFramework.getZookeeperClient().isConnected() && ZooKeeperUtils.exists((CuratorFramework)curatorFramework, (String)JVM_OPTIONS_PATH) != null) {
                return ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)JVM_OPTIONS_PATH);
            }
            return "";
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setDefaultJvmOptions(String jvmOptions) {
        this.assertValid();
        try {
            String opts = jvmOptions != null ? jvmOptions : "";
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)JVM_OPTIONS_PATH, (String)opts);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public FabricRequirements getRequirements() {
        this.assertValid();
        try {
            FabricRequirements answer = null;
            if (this.configCache.getCurrentData(REQUIREMENTS_JSON_PATH) != null) {
                String json = ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)REQUIREMENTS_JSON_PATH);
                answer = RequirementsJson.fromJSON(json);
            }
            if (answer == null) {
                answer = new FabricRequirements();
            }
            return answer;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public AutoScaleStatus getAutoScaleStatus() {
        this.assertValid();
        try {
            AutoScaleStatus answer = null;
            String zkPath = ZkPath.AUTO_SCALE_STATUS.getPath(new String[0]);
            if (this.configCache.getCurrentData(zkPath) != null) {
                String json = ZooKeeperUtils.getStringData((TreeCache)this.configCache, (String)zkPath);
                answer = RequirementsJson.autoScaleStatusFromJSON(json);
            }
            if (answer == null) {
                answer = new AutoScaleStatus();
            }
            return answer;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setRequirements(FabricRequirements requirements) throws IOException {
        this.assertValid();
        try {
            requirements.removeEmptyRequirements();
            String json = RequirementsJson.toJSON(requirements);
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)REQUIREMENTS_JSON_PATH, (String)json);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getClusterId() {
        this.assertValid();
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public List<String> getEnsembleContainers() {
        this.assertValid();
        ArrayList<String> containers = new ArrayList<String>();
        try {
            String ensemble = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{this.getClusterId()}));
            if (ensemble != null) {
                for (String name : ensemble.trim().split(",")) {
                    containers.add(name);
                }
            }
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return containers;
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }
}

