/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.DefaultLoadBalancerFactory;
import io.fabric8.camel.FabricLocatorEndpoint;
import io.fabric8.camel.FabricPublisherEndpoint;
import io.fabric8.camel.LoadBalancerFactory;
import io.fabric8.camel.ZKComponentSupport;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FabricComponent
extends ZKComponentSupport {
    private static final transient Log LOG = LogFactory.getLog(FabricComponent.class);
    private String zkRoot = "/fabric/registry/camel/endpoints";
    private LoadBalancerFactory loadBalancerFactory = new DefaultLoadBalancerFactory();
    private ProducerCache producerCache;
    private int cacheSize = 1000;

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public ProducerCache getProducerCache() {
        return this.producerCache;
    }

    public void setProducerCache(ProducerCache producerCache) {
        this.producerCache = producerCache;
    }

    public LoadBalancerFactory getLoadBalancerFactory() {
        return this.loadBalancerFactory;
    }

    public void setLoadBalancerFactory(LoadBalancerFactory loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache((Object)this, this.getCamelContext(), this.cacheSize);
        }
        ServiceHelper.startService((Service)this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
        super.doStop();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx > 0) {
            String name = remaining.substring(0, idx);
            String childUri = this.replaceAnyIpAddress(remaining.substring(idx + 1));
            if (params != null && params.size() > 0) {
                childUri = childUri + "?" + URISupport.createQueryString(params);
            }
            return new FabricPublisherEndpoint(uri, this, name, childUri);
        }
        return new FabricLocatorEndpoint(uri, this, remaining);
    }

    protected String getFabricPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty((Object)this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }

    protected String replaceAnyIpAddress(String uri) {
        String result = uri;
        return result;
    }
}

