/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.discovery;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroupFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider,
ServiceTrackerCustomizer<CuratorFramework, CuratorFramework>,
PublishClusterStateAction.NewClusterStateListener,
GroupListener<ESNode> {
    private static final Logger LOG = LoggerFactory.getLogger(FabricDiscovery.class);
    protected final ClusterName clusterName;
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final NodeSettingsService nodeSettingsService;
    protected final DiscoveryNodeService discoveryNodeService;
    protected final BundleContext context;
    protected final ServiceTracker<CuratorFramework, CuratorFramework> tracker;
    private DiscoveryNode localNode;
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    @Nullable
    private NodeService nodeService;
    private AllocationService allocationService;
    private volatile DiscoveryNodes latestDiscoNodes;
    private final PublishClusterStateAction publishClusterState;
    private volatile Group<ESNode> singleton;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    private final BlockingQueue<ProcessClusterState> processNewClusterStates = ConcurrentCollections.newBlockingQueue();

    @Inject
    public FabricDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, DiscoveryNodeService discoveryNodeService, DiscoverySettings discoverySettings) {
        super(settings);
        this.clusterName = clusterName;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettingsService = nodeSettingsService;
        this.discoveryNodeService = discoveryNodeService;
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, (DiscoveryNodesProvider)this, (PublishClusterStateAction.NewClusterStateListener)this, discoverySettings);
        this.context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        this.tracker = new ServiceTracker(this.context, CuratorFramework.class.getName(), (ServiceTrackerCustomizer)this);
    }

    protected void doStart() throws ElasticsearchException {
        this.logger.debug("Starting FabricDiscovery", new Object[0]);
        Map nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = UUID.randomUUID().toString();
        String host = this.settings.get("discovery.publish.host");
        String port = this.settings.get("discovery.publish.port");
        if (host != null && port != null) {
            InetSocketTransportAddress address = new InetSocketTransportAddress(host, Integer.parseInt(port));
            this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, (TransportAddress)address, nodeAttributes, Version.CURRENT);
        } else {
            this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes, Version.CURRENT);
        }
        this.tracker.open();
        this.logger.debug("FabricDiscovery started", new Object[0]);
    }

    protected void doStop() throws ElasticsearchException {
        this.logger.debug("Stopping FabricDiscovery", new Object[0]);
        this.tracker.close();
        this.initialStateSent.set(false);
        this.logger.debug("FabricDiscovery stopped", new Object[0]);
    }

    protected void doClose() throws ElasticsearchException {
        this.logger.debug("Closing FabricDiscovery", new Object[0]);
        this.tracker.close();
        this.publishClusterState.close();
        this.logger.debug("Closed FabricDiscovery", new Object[0]);
    }

    public DiscoveryNode localNode() {
        return this.localNode;
    }

    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    public void setNodeService(@Nullable NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        this.logger.debug("Publishing cluster state", new Object[0]);
        if (!this.singleton.isMaster()) {
            throw new ElasticsearchIllegalStateException("Shouldn't publish state when not master");
        }
        this.latestDiscoNodes = clusterState.nodes();
        this.publishClusterState.publish(clusterState, ackListener);
        this.logger.debug("Cluster state published", new Object[0]);
    }

    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.builder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    public NodeService nodeService() {
        return this.nodeService;
    }

    public CuratorFramework addingService(ServiceReference<CuratorFramework> reference) {
        CuratorFramework curator = (CuratorFramework)this.context.getService(reference);
        try {
            this.logger.debug("CuratorFramework found, starting group", new Object[0]);
            ZooKeeperGroupFactory factory = new ZooKeeperGroupFactory(curator);
            this.singleton = factory.createGroup("/fabric/registry/clusters/elasticsearch/" + this.clusterName.value(), ESNode.class);
            this.singleton.add((GroupListener)this);
            this.singleton.update((NodeState)new ESNode(this.clusterName.value(), this.localNode, false));
            this.singleton.start();
        }
        catch (Exception e) {
            LOG.error("Error starting group", (Throwable)e);
        }
        return curator;
    }

    public void modifiedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
    }

    public void removedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
        this.logger.debug("CuratorFramework lost, closing group", new Object[0]);
        try {
            this.singleton.close();
        }
        catch (IOException e) {
            LOG.error("Error stopping group", (Throwable)e);
        }
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupEvent(Group<ESNode> group, GroupListener.GroupEvent event) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FabricDiscovery.class.getClassLoader());
            this.updateCluster();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void updateCluster() {
        try {
            this.singleton.update((NodeState)new ESNode(this.clusterName.value(), this.localNode, this.singleton.isMaster()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.singleton.isMaster()) {
            if (this.logger.isDebugEnabled()) {
                String master = this.singleton.master() != null ? ((ESNode)this.singleton.master()).node.name() : null;
                ArrayList<String> slaves = new ArrayList<String>();
                for (ESNode s : this.singleton.slaves()) {
                    slaves.add(s.node.name());
                }
                this.logger.debug("Updating cluster: master {}, slaves {}", new Object[]{master, slaves});
            }
            this.clusterService.submitStateUpdateTask("fabric-discovery-master", Priority.URGENT, (ClusterStateUpdateTask)new ProcessedClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) {
                    ClusterState.Builder stateBuilder = ClusterState.builder((ClusterState)currentState);
                    DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder().localNodeId(FabricDiscovery.this.localNode.id()).masterNodeId(((ESNode)FabricDiscovery.this.singleton.master()).getNode().id()).put(((ESNode)FabricDiscovery.this.singleton.master()).getNode());
                    for (ESNode node : FabricDiscovery.this.singleton.slaves()) {
                        nodesBuilder.put(node.getNode());
                    }
                    FabricDiscovery.this.latestDiscoNodes = nodesBuilder.build();
                    stateBuilder.nodes(FabricDiscovery.this.latestDiscoNodes);
                    for (ESNode node : FabricDiscovery.this.latestDiscoNodes) {
                        if (currentState.nodes().nodeExists(node.id())) continue;
                        FabricDiscovery.this.transportService.connectToNode((DiscoveryNode)node);
                    }
                    if (!FabricDiscovery.this.localNode().id().equals(currentState.nodes().masterNodeId())) {
                        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                        stateBuilder.blocks(clusterBlocks);
                    }
                    return stateBuilder.build();
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    FabricDiscovery.this.logger.debug("Cluster updated", new Object[0]);
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                }

                public void onFailure(String source, Throwable t) {
                    FabricDiscovery.this.logger.error("unexpected failure during [{}]", t, new Object[]{source});
                }
            });
        } else if (this.singleton.master() != null) {
            DiscoveryNode masterNode = ((ESNode)this.singleton.master()).getNode();
            try {
                this.transportService.connectToNode(masterNode);
            }
            catch (Exception e) {
                this.logger.warn("failed to connect to master [{}], retrying...", (Throwable)e, new Object[]{masterNode});
            }
        }
    }

    public void onNewClusterState(ClusterState newState, final PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
        if (this.singleton.isMaster()) {
            this.logger.warn("master should not receive new cluster state from [{}]", new Object[]{newState.nodes().masterNode()});
        } else if (newState.nodes().localNode() == null) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", new Object[]{newState.nodes().masterNode()});
        } else {
            if (this.logger.isDebugEnabled()) {
                String master = this.singleton.master() != null ? ((ESNode)this.singleton.master()).node.name() : null;
                ArrayList<String> slaves = new ArrayList<String>();
                for (ESNode s : this.singleton.slaves()) {
                    slaves.add(s.node.name());
                }
                this.logger.debug("Cluster state received: master {}, slaves {}", new Object[]{master, slaves});
            }
            final ProcessClusterState processClusterState = new ProcessClusterState(newState, newStateProcessed);
            this.processNewClusterStates.add(processClusterState);
            this.clusterService.submitStateUpdateTask("fabric-discovery-slave", (ClusterStateUpdateTask)new ProcessedClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) {
                    ProcessClusterState potentialState;
                    if (processClusterState.processed) {
                        return currentState;
                    }
                    ProcessClusterState stateToProcess = (ProcessClusterState)FabricDiscovery.this.processNewClusterStates.poll();
                    if (stateToProcess == null) {
                        return currentState;
                    }
                    stateToProcess.processed = true;
                    while ((potentialState = (ProcessClusterState)FabricDiscovery.this.processNewClusterStates.peek()) != null && Objects.equal((Object)stateToProcess.clusterState.nodes().masterNodeId(), (Object)potentialState.clusterState.nodes().masterNodeId())) {
                        potentialState = (ProcessClusterState)FabricDiscovery.this.processNewClusterStates.poll();
                        potentialState.processed = true;
                        if (potentialState.clusterState.version() <= stateToProcess.clusterState.version()) continue;
                        stateToProcess = potentialState;
                    }
                    ClusterState updatedState = stateToProcess.clusterState;
                    if (updatedState.version() < currentState.version() && Objects.equal((Object)updatedState.nodes().masterNodeId(), (Object)currentState.nodes().masterNodeId())) {
                        return currentState;
                    }
                    FabricDiscovery.this.latestDiscoNodes = updatedState.nodes();
                    ClusterState.Builder builder = ClusterState.builder((ClusterState)updatedState);
                    if (updatedState.routingTable().version() == currentState.routingTable().version()) {
                        builder.routingTable(currentState.routingTable());
                    }
                    if (updatedState.metaData().version() == currentState.metaData().version()) {
                        builder.metaData(currentState.metaData());
                    } else {
                        MetaData.Builder metaDataBuilder = MetaData.builder((MetaData)updatedState.metaData()).removeAllIndices();
                        for (IndexMetaData indexMetaData : updatedState.metaData()) {
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(indexMetaData.index());
                            if (currentIndexMetaData == null || currentIndexMetaData.version() != indexMetaData.version()) {
                                metaDataBuilder.put(indexMetaData, false);
                                continue;
                            }
                            metaDataBuilder.put(currentIndexMetaData, false);
                        }
                        builder.metaData(metaDataBuilder);
                    }
                    return builder.build();
                }

                public void clusterStateProcessed(String s, ClusterState clusterState, ClusterState clusterState2) {
                    FabricDiscovery.this.logger.debug("Cluster state processed", new Object[0]);
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                    newStateProcessed.onNewClusterStateProcessed();
                }

                public void onFailure(String source, Throwable t) {
                    FabricDiscovery.this.logger.error("unexpected failure during [{}]", t, new Object[]{source});
                    newStateProcessed.onNewClusterStateFailed(t);
                }
            });
        }
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            this.logger.debug("Sending initial state event", new Object[0]);
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    static class NodeDeserializer
    extends JsonDeserializer<ESNode> {
        NodeDeserializer() {
        }

        public ESNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                Map map = (Map)jp.readValueAs(Map.class);
                String id = map.get("id").toString();
                DiscoveryNode node = (DiscoveryNode)Base64.decodeToObject((String)map.get("binary").toString(), (int)0, (ClassLoader)DiscoveryNode.class.getClassLoader());
                return new ESNode(id, node, false);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class NodeSerializer
    extends JsonSerializer<ESNode> {
        NodeSerializer() {
        }

        public void serialize(ESNode value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("id", value.getId());
            jgen.writeStringField("agent", System.getProperty("runtime.id"));
            if (value.isMaster()) {
                jgen.writeArrayFieldStart("services");
                jgen.writeString("elasticsearch");
                jgen.writeEndArray();
            }
            jgen.writeStringField("nodeName", value.getNode().name());
            jgen.writeStringField("nodeId", value.getNode().id());
            jgen.writeStringField("address", value.getNode().address().toString());
            jgen.writeStringField("version", value.getNode().version().toString());
            jgen.writeFieldName("attributes");
            jgen.writeStartObject();
            for (Map.Entry entry : value.getNode().attributes().entrySet()) {
                jgen.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            jgen.writeEndObject();
            jgen.writeStringField("binary", Base64.encodeObject((Serializable)value.getNode()));
            jgen.writeEndObject();
        }
    }

    @JsonSerialize(using=NodeSerializer.class)
    @JsonDeserialize(using=NodeDeserializer.class)
    static class ESNode
    extends NodeState {
        private final DiscoveryNode node;
        private final boolean master;

        ESNode(String id, DiscoveryNode node, boolean master) {
            super(id, node.getName());
            this.node = node;
            this.master = master;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public boolean isMaster() {
            return this.master;
        }
    }

    static class ProcessClusterState {
        final ClusterState clusterState;
        final PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed;
        volatile boolean processed;

        ProcessClusterState(ClusterState clusterState, PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
            this.clusterState = clusterState;
            this.newStateProcessed = newStateProcessed;
        }
    }
}

