/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.memory.DirectDocValuesConsumer;
import org.apache.lucene.codecs.memory.DirectDocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class DirectDocValuesFormat
extends DocValuesFormat {
    public static final int MAX_TOTAL_BYTES_LENGTH = 0x7FFFFEFF;
    public static final int MAX_SORTED_SET_ORDS = 0x7FFFFEFF;
    static final String DATA_CODEC = "DirectDocValuesData";
    static final String DATA_EXTENSION = "dvdd";
    static final String METADATA_CODEC = "DirectDocValuesMetadata";
    static final String METADATA_EXTENSION = "dvdm";

    public DirectDocValuesFormat() {
        super("Direct");
    }

    @Override
    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new DirectDocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, METADATA_CODEC, METADATA_EXTENSION);
    }

    @Override
    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new DirectDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, METADATA_CODEC, METADATA_EXTENSION);
    }
}

