/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, FSTEntry> fsts;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BytesAndAddresses> pagedBytesInstances;
    private final Map<Integer, FST<Long>> fstInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final Map<Integer, MonotonicBlockPackedReader> addresses;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final byte SORTED_SET = 4;
    static final byte SORTED_SET_SINGLETON = 5;
    static final byte SORTED_NUMERIC = 6;
    static final byte SORTED_NUMERIC_SINGLETON = 7;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte BLOCK_COMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 3;
    static final int VERSION_CURRENT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in;
            block7: {
                this.numerics = new HashMap<Integer, NumericEntry>();
                this.binaries = new HashMap<Integer, BinaryEntry>();
                this.fsts = new HashMap<Integer, FSTEntry>();
                this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                this.sortedNumerics = new HashMap<Integer, SortedNumericEntry>();
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.pagedBytesInstances = new HashMap<Integer, BytesAndAddresses>();
                this.fstInstances = new HashMap<Integer, FST<Long>>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.addresses = new HashMap<Integer, MonotonicBlockPackedReader>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                try {
                    this.version = CodecUtil.checkHeader(in, metaCodec, 3, 3);
                    this.readFields(in, state.fieldInfos);
                    CodecUtil.checkFooter(in);
                    this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 3, 3);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.data);
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.format = meta.readByte();
        switch (entry.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        entry.packedIntsVersion = meta.readVInt();
        entry.count = meta.readLong();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        if (entry.minLength != entry.maxLength) {
            entry.packedIntsVersion = meta.readVInt();
            entry.blockSize = meta.readVInt();
        }
        return entry;
    }

    private FSTEntry readFSTEntry(IndexInput meta) throws IOException {
        FSTEntry entry = new FSTEntry();
        entry.offset = meta.readLong();
        entry.numOrds = meta.readVLong();
        return entry;
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(fieldNumber, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(fieldNumber, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                this.fsts.put(fieldNumber, this.readFSTEntry(meta));
            } else if (fieldType == 4) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = false;
                this.sortedSets.put(fieldNumber, (SortedSetEntry)entry);
            } else if (fieldType == 5) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = true;
                this.sortedSets.put(fieldNumber, (SortedSetEntry)entry);
            } else if (fieldType == 6) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = false;
                ((SortedNumericEntry)entry).packedIntsVersion = meta.readVInt();
                ((SortedNumericEntry)entry).blockSize = meta.readVInt();
                ((SortedNumericEntry)entry).addressOffset = meta.readLong();
                ((SortedNumericEntry)entry).valueCount = meta.readLong();
                this.sortedNumerics.put(fieldNumber, (SortedNumericEntry)entry);
            } else if (fieldType == 7) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = true;
                this.sortedNumerics.put(fieldNumber, (SortedNumericEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.number);
        if (instance == null) {
            instance = this.loadNumeric(field);
            this.numericInstances.put(field.number, instance);
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.format) {
            case 1: {
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), entry.packedIntsVersion, (int)entry.count, bitsPerValue);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed());
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                final long minDelta = this.data.readLong();
                int formatIDDelta = this.data.readVInt();
                int bitsPerValueDelta = this.data.readVInt();
                final PackedInts.Reader deltaReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatIDDelta), entry.packedIntsVersion, (int)entry.count, bitsPerValueDelta);
                this.ramBytesUsed.addAndGet(deltaReader.ramBytesUsed());
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return minDelta + deltaReader.get(docID);
                    }
                };
            }
            case 2: {
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, entry.count, false);
                this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                return reader;
            }
            case 3: {
                final long min = this.data.readLong();
                final long mult = this.data.readLong();
                int formatIDGCD = this.data.readVInt();
                int bitsPerValueGCD = this.data.readVInt();
                final PackedInts.Reader quotientReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatIDGCD), entry.packedIntsVersion, (int)entry.count, bitsPerValueGCD);
                this.ramBytesUsed.addAndGet(quotientReader.ramBytesUsed());
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return min + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BytesAndAddresses instance;
        BinaryEntry entry = this.binaries.get(field.number);
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.pagedBytesInstances.get(field.number);
            if (instance == null) {
                instance = this.loadBinary(field);
                this.pagedBytesInstances.put(field.number, instance);
            }
        }
        final PagedBytes.Reader bytesReader = instance.reader;
        final MonotonicBlockPackedReader addresses = instance.addresses;
        if (addresses == null) {
            assert (entry.minLength == entry.maxLength);
            final int fixedLength = entry.minLength;
            return new BinaryDocValues(){
                final BytesRef term = new BytesRef();

                @Override
                public BytesRef get(int docID) {
                    bytesReader.fillSlice(this.term, (long)fixedLength * (long)docID, fixedLength);
                    return this.term;
                }
            };
        }
        return new BinaryDocValues(){
            final BytesRef term = new BytesRef();

            @Override
            public BytesRef get(int docID) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                bytesReader.fillSlice(this.term, startAddress, (int)(endAddress - startAddress));
                return this.term;
            }
        };
    }

    private BytesAndAddresses loadBinary(FieldInfo field) throws IOException {
        BytesAndAddresses bytesAndAddresses = new BytesAndAddresses();
        BinaryEntry entry = this.binaries.get(field.number);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        bytesAndAddresses.reader = bytes.freeze(true);
        this.ramBytesUsed.addAndGet(bytesAndAddresses.reader.ramBytesUsed());
        if (entry.minLength != entry.maxLength) {
            this.data.seek(this.data.getFilePointer() + entry.missingBytes);
            bytesAndAddresses.addresses = MonotonicBlockPackedReader.of(this.data, entry.packedIntsVersion, entry.blockSize, this.maxDoc, false);
            this.ramBytesUsed.addAndGet(bytesAndAddresses.addresses.ramBytesUsed());
        }
        return bytesAndAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field.number);
        if (entry.numOrds == 0L) {
            return DocValues.emptySorted();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                this.fstInstances.put(field.number, instance);
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        return new SortedDocValues(){
            final BytesRef term = new BytesRef();

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    Util.toBytesRef(output, this.term);
                    return this.term;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int getValueCount() {
                return (int)entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        MonotonicBlockPackedReader addr;
        SortedNumericEntry entry = this.sortedNumerics.get(field.number);
        if (entry.singleton) {
            NumericDocValues values = this.getNumeric(field);
            NumericEntry ne = this.numerics.get(field.number);
            Bits docsWithField = this.getMissingBits(field.number, ne.missingOffset, ne.missingBytes);
            return DocValues.singleton(values, docsWithField);
        }
        final NumericDocValues values = this.getNumeric(field);
        MemoryDocValuesProducer docsWithField = this;
        synchronized (docsWithField) {
            MonotonicBlockPackedReader res = this.addresses.get(field.number);
            if (res == null) {
                this.data.seek(entry.addressOffset);
                res = MonotonicBlockPackedReader.of(this.data, entry.packedIntsVersion, entry.blockSize, entry.valueCount, false);
                this.addresses.put(field.number, res);
            }
            addr = res;
        }
        if (values instanceof LongValues) {
            final LongValues longValues = (LongValues)values;
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int doc) {
                    this.startOffset = (int)addr.get(doc);
                    this.endOffset = (int)addr.get((long)doc + 1L);
                }

                @Override
                public long valueAt(int index) {
                    return longValues.get(this.startOffset + (long)index);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        return new SortedNumericDocValues(){
            int startOffset;
            int endOffset;

            @Override
            public void setDocument(int doc) {
                this.startOffset = (int)addr.get(doc);
                this.endOffset = (int)addr.get(doc + 1);
            }

            @Override
            public long valueAt(int index) {
                return values.get(this.startOffset + index);
            }

            @Override
            public int count() {
                return this.endOffset - this.startOffset;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST<Long> instance;
        SortedSetEntry sortedSetEntry = this.sortedSets.get(field.number);
        if (sortedSetEntry.singleton) {
            return DocValues.singleton(this.getSorted(field));
        }
        final FSTEntry entry = this.fsts.get(field.number);
        if (entry.numOrds == 0L) {
            return DocValues.emptySortedSet();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST<Long>(this.data, PositiveIntOutputs.getSingleton());
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                this.fstInstances.put(field.number, instance);
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST<Long> fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            final BytesRef term = new BytesRef();
            BytesRef ref;
            long currentOrd;

            @Override
            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            @Override
            public void setDocument(int docID) {
                this.ref = docToOrds.get(docID);
                input.reset(this.ref.bytes, this.ref.offset, this.ref.length);
                this.currentOrd = 0L;
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in, firstArc, scratchArc, scratchInts);
                    Util.toBytesRef(output, this.term);
                    return this.term;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long getValueCount() {
                return entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(field.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(field.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRef scratchBytes = new BytesRef();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum<Long>(fst);
            this.bytesReader = fst.getBytesReader();
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput<Long> io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (this.in.seekCeil(text) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals(text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public boolean seekExact(BytesRef text) throws IOException {
            return this.in.seekExact(text) != null;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, ord, this.bytesReader, this.firstArc, this.scratchArc, this.scratchInts);
            this.scratchBytes.bytes = new byte[output.length];
            this.scratchBytes.offset = 0;
            this.scratchBytes.length = 0;
            Util.toBytesRef(output, this.scratchBytes);
            this.in.seekExact(this.scratchBytes);
        }

        @Override
        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        @Override
        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class BytesAndAddresses {
        PagedBytes.Reader reader;
        MonotonicBlockPackedReader addresses;

        BytesAndAddresses() {
        }
    }

    static class SortedNumericEntry {
        boolean singleton;
        long addressOffset;
        int packedIntsVersion;
        int blockSize;
        long valueCount;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        boolean singleton;

        SortedSetEntry() {
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        long count;
        long missingOffset;
        long missingBytes;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

