/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.pulsing;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsBaseFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.pulsing.PulsingPostingsReader;
import org.apache.lucene.codecs.pulsing.PulsingPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public abstract class PulsingPostingsFormat
extends PostingsFormat {
    private final int freqCutoff;
    private final int minBlockSize;
    private final int maxBlockSize;
    private final PostingsBaseFormat wrappedPostingsBaseFormat;

    public PulsingPostingsFormat(String name, PostingsBaseFormat wrappedPostingsBaseFormat, int freqCutoff) {
        this(name, wrappedPostingsBaseFormat, freqCutoff, 25, 48);
    }

    public PulsingPostingsFormat(String name, PostingsBaseFormat wrappedPostingsBaseFormat, int freqCutoff, int minBlockSize, int maxBlockSize) {
        super(name);
        this.freqCutoff = freqCutoff;
        this.minBlockSize = minBlockSize;
        assert (minBlockSize > 1);
        this.maxBlockSize = maxBlockSize;
        this.wrappedPostingsBaseFormat = wrappedPostingsBaseFormat;
    }

    @Override
    public String toString() {
        return this.getName() + "(freqCutoff=" + this.freqCutoff + " minBlockSize=" + this.minBlockSize + " maxBlockSize=" + this.maxBlockSize + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        BlockTreeTermsWriter blockTreeTermsWriter;
        block3: {
            PostingsWriterBase docsWriter = null;
            PulsingPostingsWriter pulsingWriter = null;
            boolean success = false;
            try {
                docsWriter = this.wrappedPostingsBaseFormat.postingsWriterBase(state);
                pulsingWriter = new PulsingPostingsWriter(state, this.freqCutoff, docsWriter);
                BlockTreeTermsWriter ret = new BlockTreeTermsWriter(state, pulsingWriter, this.minBlockSize, this.maxBlockSize);
                success = true;
                blockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(docsWriter, pulsingWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(docsWriter, pulsingWriter);
        }
        return blockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        BlockTreeTermsReader blockTreeTermsReader;
        block3: {
            PostingsReaderBase docsReader = null;
            PulsingPostingsReader pulsingReader = null;
            boolean success = false;
            try {
                docsReader = this.wrappedPostingsBaseFormat.postingsReaderBase(state);
                pulsingReader = new PulsingPostingsReader(state, docsReader);
                BlockTreeTermsReader ret = new BlockTreeTermsReader(state.directory, state.fieldInfos, state.segmentInfo, pulsingReader, state.context, state.segmentSuffix, state.termsIndexDivisor);
                success = true;
                blockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(docsReader, pulsingReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(docsReader, pulsingReader);
        }
        return blockTreeTermsReader;
    }

    public int getFreqCutoff() {
        return this.freqCutoff;
    }
}

