/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.pulsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class PulsingPostingsWriter
extends PostingsWriterBase {
    static final String CODEC = "PulsedPostingsWriter";
    static final String SUMMARY_EXTENSION = "smy";
    static final int VERSION_START = 0;
    static final int VERSION_META_ARRAY = 1;
    static final int VERSION_CURRENT = 1;
    private SegmentWriteState segmentState;
    private IndexOutput termsOut;
    private List<FieldMetaData> fields;
    private FieldInfo.IndexOptions indexOptions;
    private boolean storePayloads;
    private int longsSize;
    private long[] longs;
    boolean absolute;
    private final Position[] pending;
    private int pendingCount = 0;
    private Position currentDoc;
    final PostingsWriterBase wrappedPostingsWriter;
    private boolean DEBUG;
    private final RAMOutputStream buffer = new RAMOutputStream();

    public PulsingPostingsWriter(SegmentWriteState state, int maxPositions, PostingsWriterBase wrappedPostingsWriter) {
        this.pending = new Position[maxPositions];
        for (int i = 0; i < maxPositions; ++i) {
            this.pending[i] = new Position();
        }
        this.fields = new ArrayList<FieldMetaData>();
        this.wrappedPostingsWriter = wrappedPostingsWriter;
        this.segmentState = state;
    }

    @Override
    public void init(IndexOutput termsOut) throws IOException {
        this.termsOut = termsOut;
        CodecUtil.writeHeader(termsOut, CODEC, 1);
        termsOut.writeVInt(this.pending.length);
        this.wrappedPostingsWriter.init(termsOut);
    }

    @Override
    public BlockTermState newTermState() throws IOException {
        PulsingTermState state = new PulsingTermState();
        state.wrappedState = this.wrappedPostingsWriter.newTermState();
        return state;
    }

    @Override
    public void startTerm() {
        assert (this.pendingCount == 0);
    }

    @Override
    public int setField(FieldInfo fieldInfo) {
        this.indexOptions = fieldInfo.getIndexOptions();
        this.storePayloads = fieldInfo.hasPayloads();
        this.absolute = false;
        this.longsSize = this.wrappedPostingsWriter.setField(fieldInfo);
        this.longs = new long[this.longsSize];
        this.fields.add(new FieldMetaData(fieldInfo.number, this.longsSize));
        return 0;
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        assert (docID >= 0) : "got docID=" + docID;
        if (this.pendingCount == this.pending.length) {
            this.push();
            this.wrappedPostingsWriter.finishDoc();
        }
        if (this.pendingCount != -1) {
            assert (this.pendingCount < this.pending.length);
            this.currentDoc = this.pending[this.pendingCount];
            this.currentDoc.docID = docID;
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                ++this.pendingCount;
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                ++this.pendingCount;
                this.currentDoc.termFreq = termDocFreq;
            } else {
                this.currentDoc.termFreq = termDocFreq;
            }
        } else {
            this.wrappedPostingsWriter.startDoc(docID, termDocFreq);
        }
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (this.pendingCount == this.pending.length) {
            this.push();
        }
        if (this.pendingCount == -1) {
            this.wrappedPostingsWriter.addPosition(position, payload, startOffset, endOffset);
        } else {
            Position pos = this.pending[this.pendingCount++];
            pos.pos = position;
            pos.startOffset = startOffset;
            pos.endOffset = endOffset;
            pos.docID = this.currentDoc.docID;
            if (payload != null && payload.length > 0) {
                if (pos.payload == null) {
                    pos.payload = BytesRef.deepCopyOf(payload);
                } else {
                    pos.payload.copyBytes(payload);
                }
            } else if (pos.payload != null) {
                pos.payload.length = 0;
            }
        }
    }

    @Override
    public void finishDoc() throws IOException {
        if (this.pendingCount == -1) {
            this.wrappedPostingsWriter.finishDoc();
        }
    }

    @Override
    public void finishTerm(BlockTermState _state) throws IOException {
        PulsingTermState state = (PulsingTermState)_state;
        assert (this.pendingCount > 0 || this.pendingCount == -1);
        if (this.pendingCount == -1) {
            ((PulsingTermState)state).wrappedState.docFreq = state.docFreq;
            ((PulsingTermState)state).wrappedState.totalTermFreq = state.totalTermFreq;
            PulsingTermState.access$302(state, null);
            this.wrappedPostingsWriter.finishTerm(state.wrappedState);
        } else {
            if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                int lastDocID = 0;
                int pendingIDX = 0;
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                while (pendingIDX < this.pendingCount) {
                    Position doc = this.pending[pendingIDX];
                    int delta = doc.docID - lastDocID;
                    lastDocID = doc.docID;
                    if (doc.termFreq == 1) {
                        this.buffer.writeVInt(delta << 1 | 1);
                    } else {
                        this.buffer.writeVInt(delta << 1);
                        this.buffer.writeVInt(doc.termFreq);
                    }
                    int lastPos = 0;
                    int lastOffset = 0;
                    for (int posIDX = 0; posIDX < doc.termFreq; ++posIDX) {
                        int payloadLength;
                        Position pos = this.pending[pendingIDX++];
                        assert (pos.docID == doc.docID);
                        int posDelta = pos.pos - lastPos;
                        lastPos = pos.pos;
                        int n = payloadLength = pos.payload == null ? 0 : pos.payload.length;
                        if (this.storePayloads) {
                            if (payloadLength != lastPayloadLength) {
                                this.buffer.writeVInt(posDelta << 1 | 1);
                                this.buffer.writeVInt(payloadLength);
                                lastPayloadLength = payloadLength;
                            } else {
                                this.buffer.writeVInt(posDelta << 1);
                            }
                        } else {
                            this.buffer.writeVInt(posDelta);
                        }
                        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
                            int offsetDelta = pos.startOffset - lastOffset;
                            int offsetLength = pos.endOffset - pos.startOffset;
                            if (offsetLength != lastOffsetLength) {
                                this.buffer.writeVInt(offsetDelta << 1 | 1);
                                this.buffer.writeVInt(offsetLength);
                            } else {
                                this.buffer.writeVInt(offsetDelta << 1);
                            }
                            lastOffset = pos.startOffset;
                            lastOffsetLength = offsetLength;
                        }
                        if (payloadLength <= 0) continue;
                        assert (this.storePayloads);
                        this.buffer.writeBytes(pos.payload.bytes, 0, pos.payload.length);
                    }
                }
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                int lastDocID = 0;
                for (int posIDX = 0; posIDX < this.pendingCount; ++posIDX) {
                    Position doc = this.pending[posIDX];
                    int delta = doc.docID - lastDocID;
                    assert (doc.termFreq != 0);
                    if (doc.termFreq == 1) {
                        this.buffer.writeVInt(delta << 1 | 1);
                    } else {
                        this.buffer.writeVInt(delta << 1);
                        this.buffer.writeVInt(doc.termFreq);
                    }
                    lastDocID = doc.docID;
                }
            } else if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                int lastDocID = 0;
                for (int posIDX = 0; posIDX < this.pendingCount; ++posIDX) {
                    Position doc = this.pending[posIDX];
                    this.buffer.writeVInt(doc.docID - lastDocID);
                    lastDocID = doc.docID;
                }
            }
            PulsingTermState.access$302(state, new byte[(int)this.buffer.getFilePointer()]);
            this.buffer.writeTo(state.bytes, 0);
            this.buffer.reset();
        }
        this.pendingCount = 0;
    }

    @Override
    public void encodeTerm(long[] empty, DataOutput out, FieldInfo fieldInfo, BlockTermState _state, boolean absolute) throws IOException {
        PulsingTermState state = (PulsingTermState)_state;
        assert (empty.length == 0);
        boolean bl = this.absolute = this.absolute || absolute;
        if (state.bytes == null) {
            this.wrappedPostingsWriter.encodeTerm(this.longs, this.buffer, fieldInfo, state.wrappedState, this.absolute);
            for (int i = 0; i < this.longsSize; ++i) {
                out.writeVLong(this.longs[i]);
            }
            this.buffer.writeTo(out);
            this.buffer.reset();
            this.absolute = false;
        } else {
            out.writeVInt(state.bytes.length);
            out.writeBytes(state.bytes, 0, state.bytes.length);
            this.absolute = this.absolute || absolute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.wrappedPostingsWriter.close();
        if (this.wrappedPostingsWriter instanceof PulsingPostingsWriter) {
            return;
        }
        String summaryFileName = IndexFileNames.segmentFileName(this.segmentState.segmentInfo.name, this.segmentState.segmentSuffix, SUMMARY_EXTENSION);
        IndexOutput out = null;
        try {
            out = this.segmentState.directory.createOutput(summaryFileName, this.segmentState.context);
            CodecUtil.writeHeader(out, CODEC, 1);
            out.writeVInt(this.fields.size());
            for (FieldMetaData field : this.fields) {
                out.writeVInt(field.fieldNumber);
                out.writeVInt(field.longsSize);
            }
            out.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(out);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(out);
    }

    private void push() throws IOException {
        assert (this.pendingCount == this.pending.length);
        this.wrappedPostingsWriter.startTerm();
        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            Position doc = null;
            for (Position pos : this.pending) {
                if (doc == null) {
                    doc = pos;
                    this.wrappedPostingsWriter.startDoc(doc.docID, doc.termFreq);
                } else if (doc.docID != pos.docID) {
                    assert (pos.docID > doc.docID);
                    this.wrappedPostingsWriter.finishDoc();
                    doc = pos;
                    this.wrappedPostingsWriter.startDoc(doc.docID, doc.termFreq);
                }
                this.wrappedPostingsWriter.addPosition(pos.pos, pos.payload, pos.startOffset, pos.endOffset);
            }
        } else {
            for (Position doc : this.pending) {
                this.wrappedPostingsWriter.startDoc(doc.docID, this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY ? 0 : doc.termFreq);
            }
        }
        this.pendingCount = -1;
    }

    private static final class FieldMetaData {
        int fieldNumber;
        int longsSize;

        FieldMetaData(int number, int size) {
            this.fieldNumber = number;
            this.longsSize = size;
        }
    }

    private static final class Position {
        BytesRef payload;
        int termFreq;
        int pos;
        int docID;
        int startOffset;
        int endOffset;

        private Position() {
        }
    }

    private static class PulsingTermState
    extends BlockTermState {
        private byte[] bytes;
        private BlockTermState wrappedState;

        private PulsingTermState() {
        }

        @Override
        public String toString() {
            if (this.bytes != null) {
                return "inlined";
            }
            return "not inlined wrapped=" + this.wrappedState;
        }

        static /* synthetic */ byte[] access$302(PulsingTermState x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

