/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepSkipListWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class SepPostingsWriter
extends PostingsWriterBase {
    static final String CODEC = "SepPostingsWriter";
    static final String DOC_EXTENSION = "doc";
    static final String SKIP_EXTENSION = "skp";
    static final String FREQ_EXTENSION = "frq";
    static final String POS_EXTENSION = "pos";
    static final String PAYLOAD_EXTENSION = "pyl";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    IntIndexOutput freqOut = null;
    IntIndexOutput.Index freqIndex = null;
    IntIndexOutput posOut = null;
    IntIndexOutput.Index posIndex = null;
    IntIndexOutput docOut;
    IntIndexOutput.Index docIndex;
    IndexOutput payloadOut = null;
    IndexOutput skipOut;
    final SepSkipListWriter skipListWriter;
    final int skipInterval;
    static final int DEFAULT_SKIP_INTERVAL = 16;
    final int skipMinimum;
    final int maxSkipLevels = 10;
    final int totalNumDocs;
    boolean storePayloads;
    FieldInfo.IndexOptions indexOptions;
    FieldInfo fieldInfo;
    int lastPayloadLength;
    int lastPosition;
    long payloadStart;
    int lastDocID;
    int df;
    SepTermState lastState;
    long lastPayloadFP;
    long lastSkipFP;

    public SepPostingsWriter(SegmentWriteState state, IntStreamFactory factory) throws IOException {
        this(state, factory, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SepPostingsWriter(SegmentWriteState state, IntStreamFactory factory, int skipInterval) throws IOException {
        boolean success = false;
        try {
            this.skipInterval = skipInterval;
            this.skipMinimum = skipInterval;
            String docFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, DOC_EXTENSION);
            this.docOut = factory.createOutput(state.directory, docFileName, state.context);
            this.docIndex = this.docOut.index();
            if (state.fieldInfos.hasFreq()) {
                String frqFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, FREQ_EXTENSION);
                this.freqOut = factory.createOutput(state.directory, frqFileName, state.context);
                this.freqIndex = this.freqOut.index();
            }
            if (state.fieldInfos.hasProx()) {
                String posFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, POS_EXTENSION);
                this.posOut = factory.createOutput(state.directory, posFileName, state.context);
                this.posIndex = this.posOut.index();
                String payloadFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, PAYLOAD_EXTENSION);
                this.payloadOut = state.directory.createOutput(payloadFileName, state.context);
            }
            String skipFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, SKIP_EXTENSION);
            this.skipOut = state.directory.createOutput(skipFileName, state.context);
            this.totalNumDocs = state.segmentInfo.getDocCount();
            this.skipListWriter = new SepSkipListWriter(skipInterval, 10, this.totalNumDocs, this.freqOut, this.docOut, this.posOut, this.payloadOut);
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut);
    }

    @Override
    public void init(IndexOutput termsOut) throws IOException {
        CodecUtil.writeHeader(termsOut, CODEC, 0);
        termsOut.writeInt(this.skipInterval);
        termsOut.writeInt(10);
        termsOut.writeInt(this.skipMinimum);
    }

    @Override
    public BlockTermState newTermState() {
        return new SepTermState();
    }

    @Override
    public void startTerm() throws IOException {
        this.docIndex.mark();
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqIndex.mark();
        }
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            this.posIndex.mark();
            this.payloadStart = this.payloadOut.getFilePointer();
            this.lastPayloadLength = -1;
        }
        this.skipListWriter.resetSkip(this.docIndex, this.freqIndex, this.posIndex);
    }

    @Override
    public int setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
            throw new UnsupportedOperationException("this codec cannot index offsets");
        }
        this.skipListWriter.setIndexOptions(this.indexOptions);
        this.storePayloads = this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS && fieldInfo.hasPayloads();
        this.lastPayloadFP = 0L;
        this.lastSkipFP = 0L;
        this.lastState = this.setEmptyState();
        return 0;
    }

    private SepTermState setEmptyState() {
        SepTermState emptyState = new SepTermState();
        emptyState.docIndex = this.docOut.index();
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            emptyState.freqIndex = this.freqOut.index();
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                emptyState.posIndex = this.posOut.index();
            }
        }
        emptyState.payloadFP = 0L;
        emptyState.skipFP = 0L;
        return emptyState;
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " ) (docOut: " + this.docOut + ")");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.lastPayloadLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        this.lastDocID = docID;
        this.docOut.write(delta);
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqOut.write(termDocFreq);
        }
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        int delta = position - this.lastPosition;
        assert (delta >= 0) : "position=" + position + " lastPosition=" + this.lastPosition;
        this.lastPosition = position;
        if (this.storePayloads) {
            int payloadLength;
            int n = payloadLength = payload == null ? 0 : payload.length;
            if (payloadLength != this.lastPayloadLength) {
                this.lastPayloadLength = payloadLength;
                this.posOut.write(delta << 1 | 1);
                this.posOut.write(payloadLength);
            } else {
                this.posOut.write(delta << 1);
            }
            if (payloadLength > 0) {
                this.payloadOut.writeBytes(payload.bytes, payload.offset, payloadLength);
            }
        } else {
            this.posOut.write(delta);
        }
        this.lastPosition = position;
    }

    @Override
    public void finishDoc() {
        this.lastPosition = 0;
    }

    @Override
    public void finishTerm(BlockTermState _state) throws IOException {
        SepTermState state = (SepTermState)_state;
        assert (state.docFreq > 0);
        assert (state.docFreq == this.df);
        state.docIndex = this.docOut.index();
        state.docIndex.copyFrom(this.docIndex, false);
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            state.freqIndex = this.freqOut.index();
            state.freqIndex.copyFrom(this.freqIndex, false);
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                state.posIndex = this.posOut.index();
                state.posIndex.copyFrom(this.posIndex, false);
            } else {
                state.posIndex = null;
            }
        } else {
            state.freqIndex = null;
            state.posIndex = null;
        }
        if (this.df >= this.skipMinimum) {
            state.skipFP = this.skipOut.getFilePointer();
            this.skipListWriter.writeSkip(this.skipOut);
        } else {
            state.skipFP = -1L;
        }
        state.payloadFP = this.payloadStart;
        this.lastDocID = 0;
        this.df = 0;
    }

    @Override
    public void encodeTerm(long[] longs, DataOutput out, FieldInfo fieldInfo, BlockTermState _state, boolean absolute) throws IOException {
        SepTermState state = (SepTermState)_state;
        if (absolute) {
            this.lastSkipFP = 0L;
            this.lastPayloadFP = 0L;
            this.lastState = state;
        }
        this.lastState.docIndex.copyFrom(state.docIndex, false);
        this.lastState.docIndex.write(out, absolute);
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.lastState.freqIndex.copyFrom(state.freqIndex, false);
            this.lastState.freqIndex.write(out, absolute);
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                this.lastState.posIndex.copyFrom(state.posIndex, false);
                this.lastState.posIndex.write(out, absolute);
                if (this.storePayloads) {
                    if (absolute) {
                        out.writeVLong(state.payloadFP);
                    } else {
                        out.writeVLong(state.payloadFP - this.lastPayloadFP);
                    }
                    this.lastPayloadFP = state.payloadFP;
                }
            }
        }
        if (state.skipFP != -1L) {
            if (absolute) {
                out.writeVLong(state.skipFP);
            } else {
                out.writeVLong(state.skipFP - this.lastSkipFP);
            }
            this.lastSkipFP = state.skipFP;
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.docOut, this.skipOut, this.freqOut, this.posOut, this.payloadOut);
    }

    private static class SepTermState
    extends BlockTermState {
        public IntIndexOutput.Index docIndex;
        public IntIndexOutput.Index freqIndex;
        public IntIndexOutput.Index posIndex;
        public long payloadFP;
        public long skipFP;

        private SepTermState() {
        }
    }
}

