/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.codecs.FieldInfosReader;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldInfosWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextFieldInfosReader
extends FieldInfosReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, String segmentName, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block23: {
            ChecksumIndexInput input;
            block22: {
                String fileName = IndexFileNames.segmentFileName(segmentName, segmentSuffix, "inf");
                input = directory.openChecksumInput(fileName, iocontext);
                BytesRef scratch = new BytesRef();
                boolean success = false;
                try {
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NUMFIELDS));
                    int size = Integer.parseInt(this.readString(SimpleTextFieldInfosWriter.NUMFIELDS.length, scratch));
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        FieldInfo.IndexOptions indexOptions;
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NAME));
                        String name = this.readString(SimpleTextFieldInfosWriter.NAME.length, scratch);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NUMBER));
                        int fieldNumber = Integer.parseInt(this.readString(SimpleTextFieldInfosWriter.NUMBER.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.ISINDEXED));
                        boolean isIndexed = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosWriter.ISINDEXED.length, scratch));
                        if (isIndexed) {
                            SimpleTextUtil.readLine(input, scratch);
                            assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.INDEXOPTIONS));
                            indexOptions = FieldInfo.IndexOptions.valueOf(this.readString(SimpleTextFieldInfosWriter.INDEXOPTIONS.length, scratch));
                        } else {
                            indexOptions = null;
                        }
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.STORETV));
                        boolean storeTermVector = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosWriter.STORETV.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.PAYLOADS));
                        boolean storePayloads = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosWriter.PAYLOADS.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NORMS));
                        boolean omitNorms = !Boolean.parseBoolean(this.readString(SimpleTextFieldInfosWriter.NORMS.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NORMS_TYPE));
                        String nrmType = this.readString(SimpleTextFieldInfosWriter.NORMS_TYPE.length, scratch);
                        FieldInfo.DocValuesType normsType = this.docValuesType(nrmType);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.DOCVALUES));
                        String dvType = this.readString(SimpleTextFieldInfosWriter.DOCVALUES.length, scratch);
                        FieldInfo.DocValuesType docValuesType = this.docValuesType(dvType);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.DOCVALUES_GEN));
                        long dvGen = Long.parseLong(this.readString(SimpleTextFieldInfosWriter.DOCVALUES_GEN.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.NUM_ATTS));
                        int numAtts = Integer.parseInt(this.readString(SimpleTextFieldInfosWriter.NUM_ATTS.length, scratch));
                        HashMap<String, String> atts = new HashMap<String, String>();
                        for (int j = 0; j < numAtts; ++j) {
                            SimpleTextUtil.readLine(input, scratch);
                            assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.ATT_KEY));
                            String key = this.readString(SimpleTextFieldInfosWriter.ATT_KEY.length, scratch);
                            SimpleTextUtil.readLine(input, scratch);
                            assert (StringHelper.startsWith(scratch, SimpleTextFieldInfosWriter.ATT_VALUE));
                            String value = this.readString(SimpleTextFieldInfosWriter.ATT_VALUE.length, scratch);
                            atts.put(key, value);
                        }
                        infos[i] = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, normsType, dvGen, Collections.unmodifiableMap(atts));
                    }
                    SimpleTextUtil.checkFooter(input);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block22;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException(input);
                    }
                    throw throwable;
                }
                input.close();
                break block23;
            }
            IOUtils.closeWhileHandlingException(input);
        }
        return fieldInfos;
    }

    public FieldInfo.DocValuesType docValuesType(String dvType) {
        if ("false".equals(dvType)) {
            return null;
        }
        return FieldInfo.DocValuesType.valueOf(dvType);
    }

    private String readString(int offset, BytesRef scratch) {
        return new String(scratch.bytes, scratch.offset + offset, scratch.length - offset, StandardCharsets.UTF_8);
    }
}

