/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class SimpleTextFieldInfosWriter
extends FieldInfosWriter {
    static final String FIELD_INFOS_EXTENSION = "inf";
    static final BytesRef NUMFIELDS = new BytesRef("number of fields ");
    static final BytesRef NAME = new BytesRef("  name ");
    static final BytesRef NUMBER = new BytesRef("  number ");
    static final BytesRef ISINDEXED = new BytesRef("  indexed ");
    static final BytesRef STORETV = new BytesRef("  term vectors ");
    static final BytesRef STORETVPOS = new BytesRef("  term vector positions ");
    static final BytesRef STORETVOFF = new BytesRef("  term vector offsets ");
    static final BytesRef PAYLOADS = new BytesRef("  payloads ");
    static final BytesRef NORMS = new BytesRef("  norms ");
    static final BytesRef NORMS_TYPE = new BytesRef("  norms type ");
    static final BytesRef DOCVALUES = new BytesRef("  doc values ");
    static final BytesRef DOCVALUES_GEN = new BytesRef("  doc values gen ");
    static final BytesRef INDEXOPTIONS = new BytesRef("  index options ");
    static final BytesRef NUM_ATTS = new BytesRef("  attributes ");
    static final BytesRef ATT_KEY = new BytesRef("    key ");
    static final BytesRef ATT_VALUE = new BytesRef("    value ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory directory, String segmentName, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block9: {
            IndexOutput out;
            block8: {
                String fileName = IndexFileNames.segmentFileName(segmentName, segmentSuffix, FIELD_INFOS_EXTENSION);
                out = directory.createOutput(fileName, context);
                BytesRef scratch = new BytesRef();
                boolean success = false;
                try {
                    SimpleTextUtil.write(out, NUMFIELDS);
                    SimpleTextUtil.write(out, Integer.toString(infos.size()), scratch);
                    SimpleTextUtil.writeNewline(out);
                    for (FieldInfo fi : infos) {
                        SimpleTextUtil.write(out, NAME);
                        SimpleTextUtil.write(out, fi.name, scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NUMBER);
                        SimpleTextUtil.write(out, Integer.toString(fi.number), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, ISINDEXED);
                        SimpleTextUtil.write(out, Boolean.toString(fi.isIndexed()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        if (fi.isIndexed()) {
                            assert (fi.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                            SimpleTextUtil.write(out, INDEXOPTIONS);
                            SimpleTextUtil.write(out, fi.getIndexOptions().toString(), scratch);
                            SimpleTextUtil.writeNewline(out);
                        }
                        SimpleTextUtil.write(out, STORETV);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasVectors()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, PAYLOADS);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasPayloads()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NORMS);
                        SimpleTextUtil.write(out, Boolean.toString(!fi.omitsNorms()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NORMS_TYPE);
                        SimpleTextUtil.write(out, SimpleTextFieldInfosWriter.getDocValuesType(fi.getNormType()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES);
                        SimpleTextUtil.write(out, SimpleTextFieldInfosWriter.getDocValuesType(fi.getDocValuesType()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES_GEN);
                        SimpleTextUtil.write(out, Long.toString(fi.getDocValuesGen()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        Map<String, String> atts = fi.attributes();
                        int numAtts = atts == null ? 0 : atts.size();
                        SimpleTextUtil.write(out, NUM_ATTS);
                        SimpleTextUtil.write(out, Integer.toString(numAtts), scratch);
                        SimpleTextUtil.writeNewline(out);
                        if (numAtts <= 0) continue;
                        for (Map.Entry<String, String> entry : atts.entrySet()) {
                            SimpleTextUtil.write(out, ATT_KEY);
                            SimpleTextUtil.write(out, entry.getKey(), scratch);
                            SimpleTextUtil.writeNewline(out);
                            SimpleTextUtil.write(out, ATT_VALUE);
                            SimpleTextUtil.write(out, entry.getValue(), scratch);
                            SimpleTextUtil.writeNewline(out);
                        }
                    }
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        out.close();
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                out.close();
                break block9;
            }
            IOUtils.closeWhileHandlingException(out);
        }
    }

    private static String getDocValuesType(FieldInfo.DocValuesType type) {
        return type == null ? "false" : type.toString();
    }
}

