/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class SimpleTextSegmentInfoWriter
extends SegmentInfoWriter {
    static final BytesRef SI_VERSION = new BytesRef("    version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef("    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef("    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef("    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef("      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef("      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef("    files ");
    static final BytesRef SI_FILE = new BytesRef("      file ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory dir, SegmentInfo si, FieldInfos fis, IOContext ioContext) throws IOException {
        block13: {
            IndexOutput output;
            block12: {
                String segFileName = IndexFileNames.segmentFileName(si.name, "", "si");
                si.addFile(segFileName);
                boolean success = false;
                output = dir.createOutput(segFileName, ioContext);
                try {
                    Set<String> files;
                    BytesRef scratch = new BytesRef();
                    SimpleTextUtil.write(output, SI_VERSION);
                    SimpleTextUtil.write(output, si.getVersion(), scratch);
                    SimpleTextUtil.writeNewline(output);
                    SimpleTextUtil.write(output, SI_DOCCOUNT);
                    SimpleTextUtil.write(output, Integer.toString(si.getDocCount()), scratch);
                    SimpleTextUtil.writeNewline(output);
                    SimpleTextUtil.write(output, SI_USECOMPOUND);
                    SimpleTextUtil.write(output, Boolean.toString(si.getUseCompoundFile()), scratch);
                    SimpleTextUtil.writeNewline(output);
                    Map<String, String> diagnostics = si.getDiagnostics();
                    int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
                    SimpleTextUtil.write(output, SI_NUM_DIAG);
                    SimpleTextUtil.write(output, Integer.toString(numDiagnostics), scratch);
                    SimpleTextUtil.writeNewline(output);
                    if (numDiagnostics > 0) {
                        for (Map.Entry<String, String> diagEntry : diagnostics.entrySet()) {
                            SimpleTextUtil.write(output, SI_DIAG_KEY);
                            SimpleTextUtil.write(output, diagEntry.getKey(), scratch);
                            SimpleTextUtil.writeNewline(output);
                            SimpleTextUtil.write(output, SI_DIAG_VALUE);
                            SimpleTextUtil.write(output, diagEntry.getValue(), scratch);
                            SimpleTextUtil.writeNewline(output);
                        }
                    }
                    int numFiles = (files = si.files()) == null ? 0 : files.size();
                    SimpleTextUtil.write(output, SI_NUM_FILES);
                    SimpleTextUtil.write(output, Integer.toString(numFiles), scratch);
                    SimpleTextUtil.writeNewline(output);
                    if (numFiles > 0) {
                        for (String fileName : files) {
                            SimpleTextUtil.write(output, SI_FILE);
                            SimpleTextUtil.write(output, fileName, scratch);
                            SimpleTextUtil.writeNewline(output);
                        }
                    }
                    SimpleTextUtil.writeChecksum(output, scratch);
                    success = true;
                    if (success) break block12;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(output);
                        try {
                            dir.deleteFile(segFileName);
                        }
                        catch (Throwable t) {}
                    } else {
                        output.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(output);
                try {
                    dir.deleteFile(segFileName);
                }
                catch (Throwable t) {}
                break block13;
            }
            output.close();
        }
    }
}

