/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Version;

public final class XSimpleBindings
extends Bindings {
    final Map<String, Object> map = new HashMap<String, Object>();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void add(SortField sortField) {
        this.map.put(sortField.getField(), sortField);
    }

    public void add(String name, ValueSource source) {
        this.map.put(name, source);
    }

    public void add(String name, Expression expression) {
        this.map.put(name, expression);
    }

    public ValueSource getValueSource(String name) {
        Object o = this.map.get(name);
        if (o == null) {
            throw new IllegalArgumentException("Invalid reference '" + name + "'");
        }
        if (o instanceof Expression) {
            return ((Expression)o).getValueSource((Bindings)this);
        }
        if (o instanceof ValueSource) {
            return (ValueSource)o;
        }
        SortField field = (SortField)o;
        switch (field.getType()) {
            case INT: {
                return new IntFieldSource(field.getField());
            }
            case LONG: {
                return new LongFieldSource(field.getField());
            }
            case FLOAT: {
                return new FloatFieldSource(field.getField());
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getField());
            }
            case SCORE: {
                return this.getScoreValueSource();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void validate() {
        for (Object o : this.map.values()) {
            if (!(o instanceof Expression)) continue;
            Expression expr = (Expression)o;
            try {
                expr.getValueSource((Bindings)this);
            }
            catch (StackOverflowError e) {
                throw new IllegalArgumentException("Recursion Error: Cycle detected originating in (" + expr.sourceText + ")");
            }
        }
    }

    static {
        boolean bl = $assertionsDisabled = !XSimpleBindings.class.desiredAssertionStatus();
        if (!$assertionsDisabled && org.elasticsearch.Version.CURRENT.luceneVersion != Version.LUCENE_4_9) {
            throw new AssertionError((Object)"Remove this code once we upgrade to Lucene 4.10 (LUCENE-5806)");
        }
    }
}

