/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public class XOrdinalMap
implements Accountable {
    private static final long BASE_RAM_BYTES_USED;
    final Object owner;
    final MonotonicAppendingLongBuffer globalOrdDeltas;
    final AppendingPackedLongBuffer firstSegments;
    final LongValues[] segmentToGlobalOrds;
    final SegmentMap segmentMap;
    final long ramBytesUsed;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static XOrdinalMap build(Object owner, SortedDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            subs[i] = values[i].termsEnum();
            weights[i] = values[i].getValueCount();
        }
        return XOrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static XOrdinalMap build(Object owner, SortedSetDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            subs[i] = values[i].termsEnum();
            weights[i] = values[i].getValueCount();
        }
        return XOrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static XOrdinalMap build(Object owner, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
        if (subs.length != weights.length) {
            throw new IllegalArgumentException("subs and weights must have the same length");
        }
        SegmentMap segmentMap = new SegmentMap(weights);
        return new XOrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio);
    }

    XOrdinalMap(Object owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
        this.owner = owner;
        this.segmentMap = segmentMap;
        this.globalOrdDeltas = new MonotonicAppendingLongBuffer(0.0f);
        this.firstSegments = new AppendingPackedLongBuffer(0.0f);
        MonotonicAppendingLongBuffer[] ordDeltas = new MonotonicAppendingLongBuffer[subs.length];
        for (int i = 0; i < ordDeltas.length; ++i) {
            ordDeltas[i] = new MonotonicAppendingLongBuffer(acceptableOverheadRatio);
        }
        long[] ordDeltaBits = new long[subs.length];
        long[] segmentOrds = new long[subs.length];
        ReaderSlice[] slices = new ReaderSlice[subs.length];
        MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = new ReaderSlice(0, 0, i);
            indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
        }
        MultiTermsEnum mte = new MultiTermsEnum(slices);
        mte.reset(indexes);
        long globalOrd = 0L;
        while (mte.next() != null) {
            MultiTermsEnum.TermsEnumWithSlice[] matches = mte.getMatchArray();
            int firstSegmentIndex = Integer.MAX_VALUE;
            long globalOrdDelta = Long.MAX_VALUE;
            for (int i = 0; i < mte.getMatchCount(); ++i) {
                int segmentIndex = matches[i].index;
                long segmentOrd = matches[i].terms.ord();
                long delta = globalOrd - segmentOrd;
                if (segmentIndex < firstSegmentIndex) {
                    firstSegmentIndex = segmentIndex;
                    globalOrdDelta = delta;
                }
                while (segmentOrds[segmentIndex] <= segmentOrd) {
                    int n = segmentIndex;
                    ordDeltaBits[n] = ordDeltaBits[n] | delta;
                    ordDeltas[segmentIndex].add(delta);
                    int n2 = segmentIndex;
                    segmentOrds[n2] = segmentOrds[n2] + 1L;
                }
            }
            if (!$assertionsDisabled && firstSegmentIndex >= segmentOrds.length) {
                throw new AssertionError();
            }
            this.firstSegments.add(firstSegmentIndex);
            this.globalOrdDeltas.add(globalOrdDelta);
            ++globalOrd;
        }
        this.firstSegments.freeze();
        this.globalOrdDeltas.freeze();
        for (int i = 0; i < ordDeltas.length; ++i) {
            ordDeltas[i].freeze();
        }
        this.segmentToGlobalOrds = new LongValues[subs.length];
        long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
        for (int i = 0; i < ordDeltas.length; ++i) {
            final MonotonicAppendingLongBuffer deltas = ordDeltas[i];
            if (ordDeltaBits[i] == 0L) {
                this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                continue;
            }
            int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
            long monotonicBits = deltas.ramBytesUsed() * 8L;
            long packedBits = (long)bitsRequired * deltas.size();
            if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                int size = (int)deltas.size();
                final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                AbstractAppendingLongBuffer.Iterator it = deltas.iterator();
                for (int ord = 0; ord < size; ++ord) {
                    newDeltas.set(ord, it.next());
                }
                if (!$assertionsDisabled && it.hasNext()) {
                    throw new AssertionError();
                }
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + newDeltas.get((int)ord);
                    }
                };
                ramBytesUsed += newDeltas.ramBytesUsed();
            } else {
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + deltas.get(ord);
                    }
                };
                ramBytesUsed += deltas.ramBytesUsed();
            }
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
        }
        this.ramBytesUsed = ramBytesUsed;
    }

    public LongValues getGlobalOrds(int segmentIndex) {
        return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
    }

    public long getFirstSegmentOrd(long globalOrd) {
        return globalOrd - this.globalOrdDeltas.get(globalOrd);
    }

    public int getFirstSegmentNumber(long globalOrd) {
        return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
    }

    public long getValueCount() {
        return this.globalOrdDeltas.size();
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    static {
        boolean bl = $assertionsDisabled = !XOrdinalMap.class.desiredAssertionStatus();
        if (!$assertionsDisabled && org.elasticsearch.Version.CURRENT.luceneVersion != Version.LUCENE_4_9) {
            throw new AssertionError((Object)"Remove this code once we upgrade to Lucene 4.10 (LUCENE-5780, LUCENE-5782)");
        }
        BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(XOrdinalMap.class);
    }

    private static class SegmentMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
        private final int[] newToOld;
        private final int[] oldToNew;

        private static int[] map(final long[] weights) {
            final int[] newToOld = new int[weights.length];
            for (int i = 0; i < weights.length; ++i) {
                newToOld[i] = i;
            }
            new InPlaceMergeSorter(){

                @Override
                protected void swap(int i, int j) {
                    int tmp = newToOld[i];
                    newToOld[i] = newToOld[j];
                    newToOld[j] = tmp;
                }

                @Override
                protected int compare(int i, int j) {
                    return Long.compare(weights[newToOld[j]], weights[newToOld[i]]);
                }
            }.sort(0, weights.length);
            return newToOld;
        }

        private static int[] inverse(int[] map) {
            int[] inverse = new int[map.length];
            for (int i = 0; i < map.length; ++i) {
                inverse[map[i]] = i;
            }
            return inverse;
        }

        SegmentMap(long[] weights) {
            this.newToOld = SegmentMap.map(weights);
            this.oldToNew = SegmentMap.inverse(this.newToOld);
            assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
        }

        int newToOld(int segment) {
            return this.newToOld[segment];
        }

        int oldToNew(int segment) {
            return this.oldToNew[segment];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
        }
    }
}

