/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.store.StoreUtils;

public final class RateLimitedFSDirectory
extends FilterDirectory {
    private final StoreRateLimiting.Provider rateLimitingProvider;
    private final StoreRateLimiting.Listener rateListener;

    public RateLimitedFSDirectory(Directory wrapped, StoreRateLimiting.Provider rateLimitingProvider, StoreRateLimiting.Listener rateListener) {
        super(wrapped);
        this.rateLimitingProvider = rateLimitingProvider;
        this.rateListener = rateListener;
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput output = this.in.createOutput(name, context);
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return output;
        }
        if (context.context == IOContext.Context.MERGE || type == StoreRateLimiting.Type.ALL) {
            return new RateLimitedIndexOutput(new RateLimiterWrapper(limiter, this.rateListener), output);
        }
        return output;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public String toString() {
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return StoreUtils.toString(this.in);
        }
        return "rate_limited(" + StoreUtils.toString(this.in) + ", type=" + type.name() + ", rate=" + limiter.getMbPerSec() + ")";
    }

    static final class RateLimiterWrapper
    extends RateLimiter {
        private final RateLimiter delegate;
        private final StoreRateLimiting.Listener rateListener;

        RateLimiterWrapper(RateLimiter delegate, StoreRateLimiting.Listener rateListener) {
            this.delegate = delegate;
            this.rateListener = rateListener;
        }

        @Override
        public void setMbPerSec(double mbPerSec) {
            this.delegate.setMbPerSec(mbPerSec);
        }

        @Override
        public double getMbPerSec() {
            return this.delegate.getMbPerSec();
        }

        @Override
        public long pause(long bytes) {
            long pause = this.delegate.pause(bytes);
            this.rateListener.onPause(pause);
            return pause;
        }

        @Override
        public long getMinPauseCheckBytes() {
            return this.delegate.getMinPauseCheckBytes();
        }
    }
}

