/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.delete;

import java.util.HashSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.flush.TransportFlushAction;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.refresh.TransportRefreshAction;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.TransportDeleteByQueryAction;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TypeFilterBuilder;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteMappingAction
extends TransportMasterNodeOperationAction<DeleteMappingRequest, DeleteMappingResponse> {
    private final MetaDataMappingService metaDataMappingService;
    private final TransportFlushAction flushAction;
    private final TransportDeleteByQueryAction deleteByQueryAction;
    private final TransportRefreshAction refreshAction;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportDeleteMappingAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, TransportDeleteByQueryAction deleteByQueryAction, TransportRefreshAction refreshAction, TransportFlushAction flushAction, NodeSettingsService nodeSettingsService) {
        super(settings, "indices/mapping/delete", transportService, clusterService, threadPool);
        this.metaDataMappingService = metaDataMappingService;
        this.deleteByQueryAction = deleteByQueryAction;
        this.refreshAction = refreshAction;
        this.flushAction = flushAction;
        this.destructiveOperations = new DestructiveOperations(this.logger, settings, nodeSettingsService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected DeleteMappingRequest newRequest() {
        return new DeleteMappingRequest();
    }

    @Override
    protected DeleteMappingResponse newResponse() {
        return new DeleteMappingResponse();
    }

    @Override
    protected void doExecute(DeleteMappingRequest request, ActionListener<DeleteMappingResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteMappingRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, state.metaData().concreteIndices(request.indicesOptions(), request.indices()));
    }

    @Override
    protected void masterOperation(final DeleteMappingRequest request, ClusterState state, final ActionListener<DeleteMappingResponse> listener) throws ElasticsearchException {
        final String[] concreteIndices = state.metaData().concreteIndices(request.indicesOptions(), request.indices());
        this.flushAction.execute(Requests.flushRequest(concreteIndices), new ActionListener<FlushResponse>(){

            @Override
            public void onResponse(FlushResponse flushResponse) {
                if (TransportDeleteMappingAction.this.logger.isTraceEnabled()) {
                    TransportDeleteMappingAction.this.traceLogResponse("Flush", flushResponse);
                }
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> result = TransportDeleteMappingAction.this.clusterService.state().metaData().findMappings(concreteIndices, request.types());
                BoolFilterBuilder filterBuilder = new BoolFilterBuilder();
                HashSet types = new HashSet();
                for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : result) {
                    for (ObjectObjectCursor type : (ImmutableOpenMap)objectObjectCursor.value) {
                        filterBuilder.should((FilterBuilder)new TypeFilterBuilder((String)type.key));
                        types.add(type.key);
                    }
                }
                if (types.size() == 0) {
                    throw new TypeMissingException(new Index("_all"), request.types(), "No index has the type.");
                }
                request.types(types.toArray(new String[types.size()]));
                QuerySourceBuilder querySourceBuilder = new QuerySourceBuilder().setQuery(QueryBuilders.filteredQuery(QueryBuilders.matchAllQuery(), filterBuilder));
                TransportDeleteMappingAction.this.deleteByQueryAction.execute(Requests.deleteByQueryRequest(concreteIndices).types(request.types()).source(querySourceBuilder), new ActionListener<DeleteByQueryResponse>(){

                    @Override
                    public void onResponse(DeleteByQueryResponse deleteByQueryResponse) {
                        if (TransportDeleteMappingAction.this.logger.isTraceEnabled()) {
                            for (IndexDeleteByQueryResponse indexResponse : deleteByQueryResponse) {
                                TransportDeleteMappingAction.this.logger.trace("Delete by query[{}] completed with total[{}], successful[{}] and failed[{}]", indexResponse.getIndex(), indexResponse.getTotalShards(), indexResponse.getSuccessfulShards(), indexResponse.getFailedShards());
                                if (indexResponse.getFailedShards() <= 0) continue;
                                for (ShardOperationFailedException failure : indexResponse.getFailures()) {
                                    TransportDeleteMappingAction.this.logger.trace("[{}/{}] Delete by query shard failure reason: {}", failure.index(), failure.shardId(), failure.reason());
                                }
                            }
                        }
                        TransportDeleteMappingAction.this.refreshAction.execute(Requests.refreshRequest(concreteIndices), new ActionListener<RefreshResponse>(){

                            @Override
                            public void onResponse(RefreshResponse refreshResponse) {
                                if (TransportDeleteMappingAction.this.logger.isTraceEnabled()) {
                                    TransportDeleteMappingAction.this.traceLogResponse("Refresh", refreshResponse);
                                }
                                this.removeMapping();
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                if (TransportDeleteMappingAction.this.logger.isDebugEnabled()) {
                                    TransportDeleteMappingAction.this.logger.debug("Refresh failed completely", e, new Object[0]);
                                }
                                this.removeMapping();
                            }

                            protected void removeMapping() {
                                DeleteMappingClusterStateUpdateRequest clusterStateUpdateRequest = (DeleteMappingClusterStateUpdateRequest)((DeleteMappingClusterStateUpdateRequest)((DeleteMappingClusterStateUpdateRequest)new DeleteMappingClusterStateUpdateRequest().indices(concreteIndices)).types(request.types()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
                                TransportDeleteMappingAction.this.metaDataMappingService.removeMapping(clusterStateUpdateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                                    @Override
                                    public void onResponse(ClusterStateUpdateResponse response) {
                                        listener.onResponse(new DeleteMappingResponse(response.isAcknowledged()));
                                    }

                                    @Override
                                    public void onFailure(Throwable t) {
                                        listener.onFailure(t);
                                    }
                                });
                            }
                        });
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        listener.onFailure(t);
                    }
                });
            }

            @Override
            public void onFailure(Throwable t) {
                listener.onFailure(t);
            }
        });
    }

    private void traceLogResponse(String action, BroadcastOperationResponse response) {
        this.logger.trace("{} completed with total[{}], successful[{}] and failed[{}]", action, response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards());
        if (response.getFailedShards() > 0) {
            for (ShardOperationFailedException failure : response.getShardFailures()) {
                this.logger.trace("[{}/{}] {} shard failure reason: {}", failure.index(), failure.shardId(), action, failure.reason());
            }
        }
    }
}

