/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.get.TransportShardMultiGetAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportMultiGetAction
extends TransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;

    @Inject
    public TransportMultiGetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction) {
        super(settings, "mget", threadPool);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        transportService.registerHandler("mget", new TransportHandler());
    }

    @Override
    protected void doExecute(MultiGetRequest request, final ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            MultiGetRequest.Item item = request.items.get(i);
            if (!clusterState.metaData().hasConcreteIndex(item.index())) {
                responses.set(i, new MultiGetItemResponse(null, new MultiGetResponse.Failure(item.index(), item.type(), item.id(), "[" + item.index() + "] missing")));
                continue;
            }
            item.routing(clusterState.metaData().resolveIndexRouting(item.routing(), item.index()));
            item.index(clusterState.metaData().concreteSingleIndex(item.index()));
            if (item.routing() == null && clusterState.getMetaData().routingRequired(item.index(), item.type())) {
                responses.set(i, new MultiGetItemResponse(null, new MultiGetResponse.Failure(item.index(), item.type(), item.id(), "routing is required for [" + item.index() + "]/[" + item.type() + "]/[" + item.id() + "]")));
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, item.index(), item.type(), item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(shardId.index().name(), shardId.id());
                shardRequest.preference(request.preference);
                shardRequest.realtime(request.realtime);
                shardRequest.refresh(request.refresh);
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item.type(), item.id(), item.fields(), item.version(), item.versionType(), item.fetchSourceContext());
        }
        if (shardRequests.size() == 0) {
            listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
        }
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        responses.set(response.locations.get(i), new MultiGetItemResponse(response.responses.get(i), response.failures.get(i)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    String message = ExceptionsHelper.detailedMessage(e);
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        responses.set(shardRequest.locations.get(i), new MultiGetItemResponse(null, new MultiGetResponse.Failure(shardRequest.index(), shardRequest.types.get(i), shardRequest.ids.get(i), message)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<MultiGetRequest> {
        TransportHandler() {
        }

        @Override
        public MultiGetRequest newInstance() {
            return new MultiGetRequest();
        }

        @Override
        public void messageReceived(final MultiGetRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMultiGetAction.this.execute(request, new ActionListener<MultiGetResponse>(){

                @Override
                public void onResponse(MultiGetResponse response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMultiGetAction.this.logger.warn("Failed to send error response for action [mget] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

