/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class GetIndexedScriptRequest
extends SingleShardOperationRequest<GetIndexedScriptRequest> {
    protected String scriptLang;
    protected String id;
    protected String preference;
    protected String routing;
    private FetchSourceContext fetchSourceContext;
    private boolean refresh = false;
    Boolean realtime;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;

    public GetIndexedScriptRequest() {
        super(".scripts");
    }

    public GetIndexedScriptRequest(String index, String scriptLang, String id) {
        super(index);
        this.scriptLang = scriptLang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    public GetIndexedScriptRequest scriptLang(@Nullable String type) {
        this.scriptLang = type;
        return this;
    }

    public GetIndexedScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetIndexedScriptRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String[] fields() {
        return null;
    }

    public GetIndexedScriptRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetIndexedScriptRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public GetIndexedScriptRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public long version() {
        return this.version;
    }

    public GetIndexedScriptRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetIndexedScriptRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scriptLang = in.readString();
        this.id = in.readString();
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = Versions.readVersionWithVLongForBW(in);
        this.fetchSourceContext = FetchSourceContext.optionalReadFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scriptLang);
        out.writeString(this.id);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
        out.writeByte(this.versionType.getValue());
        Versions.writeVersionWithVLongForBW(this.version, out);
        FetchSourceContext.optionalWriteToStream(this.fetchSourceContext, out);
    }

    public String toString() {
        return "[" + this.index + "][" + this.scriptLang + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

