/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QueryFetchSearchResult> {
        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchQueryAndFetchAction.this, request, listener);
        }

        @Override
        protected String firstPhaseName() {
            return "query_fetch";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<QueryFetchSearchResult> listener) {
            TransportSearchQueryAndFetchAction.this.searchService.sendExecuteFetch(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", e, this.buildShardFailures());
                if (TransportSearchQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchQueryAndFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
        }

        private void innerFinishHim() throws IOException {
            boolean useScroll = !this.useSlowScroll && this.request.scroll() != null;
            this.sortedShardList = TransportSearchQueryAndFetchAction.this.searchPhaseController.sortDocs(useScroll, this.firstResults);
            InternalSearchResponse internalResponse = TransportSearchQueryAndFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.firstResults, this.firstResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

