/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;

public class TermVectorRequest
extends SingleShardOperationRequest<TermVectorRequest> {
    private String type;
    private String id;
    private String routing;
    protected String preference;
    private Set<String> selectedFields;
    private EnumSet<Flag> flagsEnum = EnumSet.of(Flag.Positions, Flag.Offsets, Flag.Payloads, Flag.FieldStatistics);

    public TermVectorRequest() {
    }

    public TermVectorRequest(String index, String type, String id) {
        super(index);
        this.id = id;
        this.type = type;
    }

    public TermVectorRequest(TermVectorRequest other) {
        super(other.index());
        this.id = other.id();
        this.type = other.type();
        this.flagsEnum = other.getFlags().clone();
        this.preference = other.preference();
        this.routing = other.routing();
        if (other.selectedFields != null) {
            this.selectedFields = new HashSet<String>(other.selectedFields);
        }
    }

    public EnumSet<Flag> getFlags() {
        return this.flagsEnum;
    }

    public TermVectorRequest type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public TermVectorRequest id(String id) {
        this.id = id;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public TermVectorRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public TermVectorRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public TermVectorRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public TermVectorRequest offsets(boolean offsets) {
        this.setFlag(Flag.Offsets, offsets);
        return this;
    }

    public boolean offsets() {
        return this.flagsEnum.contains((Object)Flag.Offsets);
    }

    public TermVectorRequest positions(boolean positions) {
        this.setFlag(Flag.Positions, positions);
        return this;
    }

    public boolean positions() {
        return this.flagsEnum.contains((Object)Flag.Positions);
    }

    public boolean payloads() {
        return this.flagsEnum.contains((Object)Flag.Payloads);
    }

    public TermVectorRequest payloads(boolean payloads) {
        this.setFlag(Flag.Payloads, payloads);
        return this;
    }

    public boolean termStatistics() {
        return this.flagsEnum.contains((Object)Flag.TermStatistics);
    }

    public TermVectorRequest termStatistics(boolean termStatistics) {
        this.setFlag(Flag.TermStatistics, termStatistics);
        return this;
    }

    public boolean fieldStatistics() {
        return this.flagsEnum.contains((Object)Flag.FieldStatistics);
    }

    public TermVectorRequest fieldStatistics(boolean fieldStatistics) {
        this.setFlag(Flag.FieldStatistics, fieldStatistics);
        return this;
    }

    public Set<String> selectedFields() {
        return this.selectedFields;
    }

    public TermVectorRequest selectedFields(String[] fields) {
        this.selectedFields = fields != null && fields.length != 0 ? Sets.newHashSet(fields) : null;
        return this;
    }

    private void setFlag(Flag flag, boolean set) {
        if (set && !this.flagsEnum.contains((Object)flag)) {
            this.flagsEnum.add(flag);
        } else if (!set) {
            this.flagsEnum.remove((Object)flag);
            assert (!this.flagsEnum.contains((Object)flag));
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    public static TermVectorRequest readTermVectorRequest(StreamInput in) throws IOException {
        TermVectorRequest termVectorRequest = new TermVectorRequest();
        termVectorRequest.readFrom(in);
        return termVectorRequest;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        long flags = in.readVLong();
        this.flagsEnum.clear();
        for (Flag flag : Flag.values()) {
            if ((flags & (long)(1 << flag.ordinal())) == 0L) continue;
            this.flagsEnum.add(flag);
        }
        int numSelectedFields = in.readVInt();
        if (numSelectedFields > 0) {
            this.selectedFields = new HashSet<String>();
            for (int i = 0; i < numSelectedFields; ++i) {
                this.selectedFields.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        long longFlags = 0L;
        for (Flag flag : this.flagsEnum) {
            longFlags |= (long)(1 << flag.ordinal());
        }
        out.writeVLong(longFlags);
        if (this.selectedFields != null) {
            out.writeVInt(this.selectedFields.size());
            for (String selectedField : this.selectedFields) {
                out.writeString(selectedField);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public static void parseRequest(TermVectorRequest termVectorRequest, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        ArrayList<String> fields = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) continue;
            if (currentFieldName.equals("fields")) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    continue;
                }
                throw new ElasticsearchParseException("The parameter fields must be given as an array! Use syntax : \"fields\" : [\"field1\", \"field2\",...]");
            }
            if (currentFieldName.equals("offsets")) {
                termVectorRequest.offsets(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("positions")) {
                termVectorRequest.positions(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("payloads")) {
                termVectorRequest.payloads(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("term_statistics") || currentFieldName.equals("termStatistics")) {
                termVectorRequest.termStatistics(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("field_statistics") || currentFieldName.equals("fieldStatistics")) {
                termVectorRequest.fieldStatistics(parser.booleanValue());
                continue;
            }
            if ("_index".equals(currentFieldName)) {
                termVectorRequest.index = parser.text();
                continue;
            }
            if ("_type".equals(currentFieldName)) {
                termVectorRequest.type = parser.text();
                continue;
            }
            if ("_id".equals(currentFieldName)) {
                termVectorRequest.id = parser.text();
                continue;
            }
            if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                termVectorRequest.routing = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("The parameter " + currentFieldName + " is not valid for term vector request!");
        }
        if (fields.size() > 0) {
            String[] fieldsAsArray = new String[fields.size()];
            termVectorRequest.selectedFields(fields.toArray(fieldsAsArray));
        }
    }

    public static enum Flag {
        Positions,
        Offsets,
        Payloads,
        FieldStatistics,
        TermStatistics;

    }
}

