/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.InfoStream;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;

public final class LoggerInfoStream
extends InfoStream {
    private final ESLogger logger;

    public LoggerInfoStream(Settings settings, ShardId shardId) {
        this.logger = Loggers.getLogger("lucene.iw", settings, shardId, new String[0]);
    }

    @Override
    public void message(String component, String message) {
        this.logger.trace("{} {}: {}", Thread.currentThread().getName(), component, message);
    }

    @Override
    public boolean isEnabled(String component) {
        return this.logger.isTraceEnabled() && !component.equals("TP");
    }

    @Override
    public void close() {
    }
}

