/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;

public class SegmentReaderUtils {
    @Nullable
    public static SegmentReader segmentReader(AtomicReader reader) {
        return SegmentReaderUtils.internalSegmentReader(reader, true);
    }

    @Nullable
    public static SegmentReader segmentReaderOrNull(AtomicReader reader) {
        return SegmentReaderUtils.internalSegmentReader(reader, false);
    }

    public static boolean registerCoreListener(AtomicReader reader, AtomicReader.CoreClosedListener listener) {
        reader.addCoreClosedListener(listener);
        return true;
    }

    private static SegmentReader internalSegmentReader(AtomicReader reader, boolean fail) {
        if (reader == null) {
            return null;
        }
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterAtomicReader) {
            FilterAtomicReader fReader = (FilterAtomicReader)reader;
            return SegmentReaderUtils.segmentReader(FilterAtomicReader.unwrap(fReader));
        }
        if (fail) {
            throw new ElasticsearchIllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
        }
        return null;
    }
}

