/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;

public class OrDocIdSet
extends DocIdSet {
    private final DocIdSet[] sets;

    public OrDocIdSet(DocIdSet[] sets) {
        this.sets = sets;
    }

    @Override
    public boolean isCacheable() {
        for (DocIdSet set : this.sets) {
            if (set.isCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long ramBytesUsed() {
        long ramBytesUsed = RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        for (DocIdSet set : this.sets) {
            ramBytesUsed += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + set.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Bits bits() throws IOException {
        Bits[] bits = new Bits[this.sets.length];
        for (int i = 0; i < this.sets.length; ++i) {
            bits[i] = this.sets[i].bits();
            if (bits[i] != null) continue;
            return null;
        }
        return new OrBits(bits);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new IteratorBasedIterator(this.sets);
    }

    static class IteratorBasedIterator
    extends DocIdSetIterator {
        private int _curDoc = -1;
        private final Item[] _heap;
        private int _size;
        private final long cost;

        IteratorBasedIterator(DocIdSet[] sets) throws IOException {
            this._heap = new Item[sets.length];
            this._size = 0;
            long cost = 0L;
            for (DocIdSet set : sets) {
                DocIdSetIterator iterator = set.iterator();
                if (iterator == null) continue;
                this._heap[this._size++] = new Item(iterator);
                cost += iterator.cost();
            }
            this.cost = cost;
            if (this._size == 0) {
                this._curDoc = Integer.MAX_VALUE;
            }
        }

        @Override
        public final int docID() {
            return this._curDoc;
        }

        @Override
        public final int nextDoc() throws IOException {
            int topDoc;
            if (this._curDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            Item top = this._heap[0];
            do {
                DocIdSetIterator topIter;
                int docid;
                if ((docid = (topIter = top.iter).nextDoc()) != Integer.MAX_VALUE) {
                    top.doc = docid;
                    this.heapAdjust();
                } else {
                    this.heapRemoveRoot();
                    if (this._size == 0) {
                        this._curDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                top = this._heap[0];
            } while ((topDoc = top.doc) <= this._curDoc);
            this._curDoc = topDoc;
            return this._curDoc;
        }

        @Override
        public final int advance(int target) throws IOException {
            int topDoc;
            if (this._curDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this._curDoc) {
                target = this._curDoc + 1;
            }
            Item top = this._heap[0];
            do {
                DocIdSetIterator topIter;
                int docid;
                if ((docid = (topIter = top.iter).advance(target)) != Integer.MAX_VALUE) {
                    top.doc = docid;
                    this.heapAdjust();
                } else {
                    this.heapRemoveRoot();
                    if (this._size == 0) {
                        this._curDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
                top = this._heap[0];
            } while ((topDoc = top.doc) < target);
            this._curDoc = topDoc;
            return this._curDoc;
        }

        private final void heapAdjust() {
            int lchild;
            Item[] heap = this._heap;
            Item top = heap[0];
            int doc = top.doc;
            int size = this._size;
            int i = 0;
            while ((lchild = (i << 1) + 1) < size) {
                Item left = heap[lchild];
                int ldoc = left.doc;
                int rchild = lchild + 1;
                if (rchild < size) {
                    Item right = heap[rchild];
                    int rdoc = right.doc;
                    if (rdoc <= ldoc) {
                        if (doc <= rdoc) break;
                        heap[i] = right;
                        i = rchild;
                        continue;
                    }
                }
                if (doc <= ldoc) break;
                heap[i] = left;
                i = lchild;
            }
            heap[i] = top;
        }

        private void heapRemoveRoot() {
            --this._size;
            if (this._size > 0) {
                Item tmp = this._heap[0];
                this._heap[0] = this._heap[this._size];
                this._heap[this._size] = tmp;
                this.heapAdjust();
            }
        }

        @Override
        public long cost() {
            return this.cost;
        }

        final class Item {
            public final DocIdSetIterator iter;
            public int doc;

            public Item(DocIdSetIterator iter) {
                this.iter = iter;
                this.doc = -1;
            }
        }
    }

    static class OrBits
    implements Bits {
        private final Bits[] bits;

        OrBits(Bits[] bits) {
            this.bits = bits;
        }

        @Override
        public boolean get(int index) {
            for (Bits bit : this.bits) {
                if (!bit.get(index)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.bits[0].length();
        }
    }
}

