/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.common.lucene.search.NoCacheFilter;

public class LimitFilter
extends NoCacheFilter {
    private final int limit;
    private int counter;

    public LimitFilter(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        if (this.counter > this.limit) {
            return null;
        }
        return new LimitDocIdSet(context.reader().maxDoc(), acceptDocs, this.limit);
    }

    public class LimitDocIdSet
    extends MatchDocIdSet {
        private final int limit;

        public LimitDocIdSet(@Nullable int maxDoc, Bits acceptDocs, int limit) {
            super(maxDoc, acceptDocs);
            this.limit = limit;
        }

        @Override
        protected boolean matchDoc(int doc) {
            return ++LimitFilter.this.counter <= this.limit;
        }
    }
}

