/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.MatchAllDocsFilter;
import org.elasticsearch.common.lucene.search.MatchNoDocsFilter;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.index.search.child.CustomQueryWrappingFilter;

public class Queries {
    public static final Filter MATCH_ALL_FILTER = new MatchAllDocsFilter();
    public static final Filter MATCH_NO_FILTER = new MatchNoDocsFilter();
    private static Pattern spaceAroundLessThanPattern = Pattern.compile("(\\s+<\\s*)|(\\s*<\\s+)");
    private static Pattern spacePattern = Pattern.compile(" ");
    private static Pattern lessThanPattern = Pattern.compile("<");
    private static final QueryWrapperFilterFactory FACTORY = new QueryWrapperFilterFactory();

    public static Query newMatchAllQuery() {
        return new XConstantScoreQuery(MATCH_ALL_FILTER);
    }

    public static Query newMatchNoDocsQuery() {
        return new MatchNoDocsQuery();
    }

    public static boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List<BooleanClause> clauses = ((BooleanQuery)q).clauses();
        if (clauses.isEmpty()) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query fixNegativeQueryIfNeeded(Query q) {
        if (Queries.isNegativeQuery(q)) {
            BooleanQuery newBq = (BooleanQuery)q.clone();
            newBq.add(Queries.newMatchAllQuery(), BooleanClause.Occur.MUST);
            return newBq;
        }
        return q;
    }

    public static boolean isConstantMatchAllQuery(Query query) {
        XConstantScoreQuery scoreQuery;
        return query instanceof XConstantScoreQuery && (scoreQuery = (XConstantScoreQuery)query).getFilter() instanceof MatchAllDocsFilter;
    }

    public static void applyMinimumShouldMatch(BooleanQuery query, @Nullable String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            return;
        }
        int optionalClauses = 0;
        for (BooleanClause c : query.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = Queries.calculateMinShouldMatch(optionalClauses, minimumShouldMatch);
        if (0 < msm) {
            query.setMinimumNumberShouldMatch(msm);
        }
    }

    public static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < (spec = spec.trim()).indexOf("<")) {
            spec = spaceAroundLessThanPattern.matcher(spec).replaceAll("<");
            for (String s : spacePattern.split(spec)) {
                String[] parts = lessThanPattern.split(s, 0);
                int upperBound = Integer.parseInt(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = Queries.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf(37)) {
            int percent = Integer.parseInt(spec = spec.substring(0, spec.length() - 1));
            float calc = (float)(result * percent) * 0.01f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = Integer.parseInt(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }

    public static Filter wrap(Query query) {
        return FACTORY.wrap(query);
    }

    private static final class QueryWrapperFilterFactory {
        private QueryWrapperFilterFactory() {
        }

        public Filter wrap(Query query) {
            if (CustomQueryWrappingFilter.shouldUseCustomQueryWrappingFilter(query)) {
                return new CustomQueryWrappingFilter(query);
            }
            return new QueryWrapperFilter(query);
        }
    }
}

