/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.PerThreadIDAndVersionLookup;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class Versions {
    public static final long MATCH_ANY = -3L;
    public static final long MATCH_ANY_PRE_1_2_0 = 0L;
    public static final long NOT_FOUND = -1L;
    public static final long NOT_SET = -2L;
    private static final ConcurrentMap<IndexReader, CloseableThreadLocal<PerThreadIDAndVersionLookup>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ReaderClosedListener removeLookupState = new IndexReader.ReaderClosedListener(){

        @Override
        public void onClose(IndexReader reader) {
            CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(reader);
            if (ctl != null) {
                ctl.close();
            }
        }
    };

    private static PerThreadIDAndVersionLookup getLookupState(IndexReader reader) throws IOException {
        PerThreadIDAndVersionLookup lookupState;
        CloseableThreadLocal<PerThreadIDAndVersionLookup> ctl = (CloseableThreadLocal<PerThreadIDAndVersionLookup>)lookupStates.get(reader);
        if (ctl == null) {
            ctl = new CloseableThreadLocal<PerThreadIDAndVersionLookup>();
            CloseableThreadLocal other = lookupStates.putIfAbsent(reader, ctl);
            if (other == null) {
                reader.addReaderClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDAndVersionLookup)ctl.get()) == null) {
            lookupState = new PerThreadIDAndVersionLookup(reader);
            ctl.set(lookupState);
        }
        return lookupState;
    }

    public static void writeVersion(long version, StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_1_2_0) && version == -3L) {
            version = 0L;
        }
        out.writeLong(version);
    }

    public static long readVersion(StreamInput in) throws IOException {
        long version = in.readLong();
        if (in.getVersion().before(Version.V_1_2_0) && version == 0L) {
            version = -3L;
        }
        return version;
    }

    public static void writeVersionWithVLongForBW(long version, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeLong(version);
            return;
        }
        if (version == -3L) {
            version = 0L;
        }
        out.writeVLong(version);
    }

    public static long readVersionWithVLongForBW(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_1_2_0)) {
            return in.readLong();
        }
        long version = in.readVLong();
        if (version == 0L) {
            return -3L;
        }
        return version;
    }

    private Versions() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) throws IOException {
        assert (term.field().equals("_uid"));
        return Versions.getLookupState(reader).lookup(term.bytes());
    }

    public static long loadVersion(IndexReader reader, Term term) throws IOException {
        DocIdAndVersion docIdAndVersion = Versions.loadDocIdAndVersion(reader, term);
        return docIdAndVersion == null ? -1L : docIdAndVersion.version;
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final AtomicReaderContext context;

        public DocIdAndVersion(int docId, long version, AtomicReaderContext context) {
            this.docId = docId;
            this.version = version;
            this.context = context;
        }
    }
}

