/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.socks;

import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayingDecoder;
import org.elasticsearch.common.netty.handler.codec.socks.SocksAuthResponse;
import org.elasticsearch.common.netty.handler.codec.socks.SocksCommonUtils;
import org.elasticsearch.common.netty.handler.codec.socks.SocksMessage;
import org.elasticsearch.common.netty.handler.codec.socks.SocksResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksAuthResponseDecoder
extends ReplayingDecoder<State> {
    private static final String name = "SOCKS_AUTH_RESPONSE_DECODER";
    private SocksMessage.SubnegotiationVersion version;
    private SocksMessage.AuthStatus authStatus;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public static String getName() {
        return name;
    }

    public SocksAuthResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.SubnegotiationVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.SubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint(State.READ_AUTH_RESPONSE);
            }
            case READ_AUTH_RESPONSE: {
                this.authStatus = SocksMessage.AuthStatus.fromByte(buffer.readByte());
                this.msg = new SocksAuthResponse(this.authStatus);
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_RESPONSE;

    }
}

