/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.hppc.DoubleArrayList;
import org.elasticsearch.common.hppc.FloatArrayList;
import org.elasticsearch.common.hppc.LongArrayList;
import org.elasticsearch.common.hppc.ObjectArrayList;

public final class CollectionUtils
extends Enum<CollectionUtils> {
    private static final /* synthetic */ CollectionUtils[] $VALUES;

    public static CollectionUtils[] values() {
        return (CollectionUtils[])$VALUES.clone();
    }

    public static CollectionUtils valueOf(String name) {
        return Enum.valueOf(CollectionUtils.class, name);
    }

    public static void sort(LongArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final long[] array, int len) {
        new IntroSorter(){
            long pivot;

            @Override
            protected void swap(int i, int j) {
                long tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Long.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Long.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(LongArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(long[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (array[i] == array[i - 1]) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static void sort(FloatArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final float[] array, int len) {
        new IntroSorter(){
            float pivot;

            @Override
            protected void swap(int i, int j) {
                float tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Float.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Float.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(FloatArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(float[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (Float.compare(array[i], array[i - 1]) == 0) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static void sort(DoubleArrayList list) {
        CollectionUtils.sort(list.buffer, list.size());
    }

    public static void sort(final double[] array, int len) {
        new IntroSorter(){
            double pivot;

            @Override
            protected void swap(int i, int j) {
                double tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Double.compare(array[i], array[j]);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = array[i];
            }

            @Override
            protected int comparePivot(int j) {
                return Double.compare(this.pivot, array[j]);
            }
        }.sort(0, len);
    }

    public static void sortAndDedup(DoubleArrayList list) {
        list.elementsCount = CollectionUtils.sortAndDedup(list.buffer, list.elementsCount);
    }

    public static int sortAndDedup(double[] array, int len) {
        if (len <= 1) {
            return len;
        }
        CollectionUtils.sort(array, len);
        int uniqueCount = 1;
        for (int i = 1; i < len; ++i) {
            if (Double.compare(array[i], array[i - 1]) == 0) continue;
            array[uniqueCount++] = array[i];
        }
        return uniqueCount;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static void sortAndDedup(ObjectArrayList<byte[]> array) {
        int len = array.size();
        if (len > 1) {
            CollectionUtils.sort(array);
            int uniqueCount = 1;
            for (int i = 1; i < len; ++i) {
                if (Arrays.equals(array.get(i), array.get(i - 1))) continue;
                array.set(uniqueCount++, array.get(i));
            }
            array.elementsCount = uniqueCount;
        }
    }

    public static void sort(final ObjectArrayList<byte[]> array) {
        new IntroSorter(){
            byte[] pivot;

            @Override
            protected void swap(int i, int j) {
                byte[] tmp = (byte[])array.get(i);
                array.set(i, array.get(j));
                array.set(j, tmp);
            }

            @Override
            protected int compare(int i, int j) {
                return this.compare((byte[])array.get(i), (byte[])array.get(j));
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = (byte[])array.get(i);
            }

            @Override
            protected int comparePivot(int j) {
                return this.compare(this.pivot, (byte[])array.get(j));
            }

            private int compare(byte[] left, byte[] right) {
                int i = 0;
                for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                    int a = left[i] & 0xFF;
                    int b = right[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return left.length - right.length;
            }
        }.sort(0, array.size());
    }

    public static void sort(BytesRefArray bytes, int[] indices) {
        CollectionUtils.sort(new BytesRef(), new BytesRef(), bytes, indices);
    }

    private static void sort(final BytesRef scratch, final BytesRef scratch1, final BytesRefArray bytes, final int[] indices) {
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues > 1) {
            new InPlaceMergeSorter(){
                final Comparator<BytesRef> comparator = BytesRef.getUTF8SortedAsUnicodeComparator();

                @Override
                protected int compare(int i, int j) {
                    return this.comparator.compare(bytes.get(scratch, indices[i]), bytes.get(scratch1, indices[j]));
                }

                @Override
                protected void swap(int i, int j) {
                    int value_i = indices[i];
                    indices[i] = indices[j];
                    indices[j] = value_i;
                }
            }.sort(0, numValues);
        }
    }

    public static int sortAndDedup(BytesRefArray bytes, int[] indices) {
        BytesRef scratch = new BytesRef();
        BytesRef scratch1 = new BytesRef();
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues <= 1) {
            return numValues;
        }
        CollectionUtils.sort(scratch, scratch1, bytes, indices);
        int uniqueCount = 1;
        BytesRef previous = scratch;
        BytesRef current = scratch1;
        bytes.get(previous, indices[0]);
        for (int i = 1; i < numValues; ++i) {
            bytes.get(current, indices[i]);
            if (!previous.equals(current)) {
                indices[uniqueCount++] = indices[i];
            }
            BytesRef tmp = previous;
            previous = current;
            current = tmp;
        }
        return uniqueCount;
    }

    static {
        $VALUES = new CollectionUtils[0];
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        public RotatedList(List<T> list, int distance) {
            Preconditions.checkArgument(distance >= 0 && distance < list.size());
            Preconditions.checkArgument(list instanceof RandomAccess);
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

