/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedCallable;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;

public class PrioritizedEsThreadPoolExecutor
extends EsThreadPoolExecutor {
    private AtomicLong insertionOrder = new AtomicLong();
    private Queue<Runnable> current = ConcurrentCollections.newQueue();

    PrioritizedEsThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory);
    }

    public Pending[] getPending() {
        ArrayList<Pending> pending = Lists.newArrayList();
        this.addPending(Lists.newArrayList(this.current), pending, true);
        this.addPending(Lists.newArrayList(this.getQueue()), pending, false);
        return pending.toArray(new Pending[pending.size()]);
    }

    private void addPending(List<Runnable> runnables, List<Pending> pending, boolean executing) {
        for (Runnable runnable : runnables) {
            Comparable<PrioritizedRunnable> t;
            if (runnable instanceof TieBreakingPrioritizedRunnable) {
                t = (TieBreakingPrioritizedRunnable)runnable;
                pending.add(new Pending(((TieBreakingPrioritizedRunnable)t).runnable, ((PrioritizedRunnable)t).priority(), ((TieBreakingPrioritizedRunnable)t).insertionOrder, executing));
                continue;
            }
            if (!(runnable instanceof PrioritizedFutureTask)) continue;
            t = (PrioritizedFutureTask)runnable;
            pending.add(new Pending(((PrioritizedFutureTask)t).task, ((PrioritizedFutureTask)t).priority, ((PrioritizedFutureTask)t).insertionOrder, executing));
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.current.add(r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.current.remove(r);
    }

    public void execute(Runnable command, ScheduledExecutorService timer, TimeValue timeout, final Runnable timeoutCallback) {
        if (command instanceof PrioritizedRunnable) {
            command = new TieBreakingPrioritizedRunnable((PrioritizedRunnable)command, this.insertionOrder.incrementAndGet());
        } else if (!(command instanceof PrioritizedFutureTask)) {
            command = new TieBreakingPrioritizedRunnable(command, Priority.NORMAL, this.insertionOrder.incrementAndGet());
        }
        super.execute(command);
        if (timeout.nanos() >= 0L) {
            final Runnable fCommand = command;
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    boolean removed = PrioritizedEsThreadPoolExecutor.this.getQueue().remove(fCommand);
                    if (removed) {
                        timeoutCallback.run();
                    }
                }
            }, timeout.nanos(), TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof PrioritizedRunnable) {
            command = new TieBreakingPrioritizedRunnable((PrioritizedRunnable)command, this.insertionOrder.incrementAndGet());
        } else if (!(command instanceof PrioritizedFutureTask)) {
            command = new TieBreakingPrioritizedRunnable(command, Priority.NORMAL, this.insertionOrder.incrementAndGet());
        }
        super.execute(command);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (!(runnable instanceof PrioritizedRunnable)) {
            runnable = PrioritizedRunnable.wrap(runnable, Priority.NORMAL);
        }
        return new PrioritizedFutureTask<T>((PrioritizedRunnable)runnable, value, this.insertionOrder.incrementAndGet());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (!(callable instanceof PrioritizedCallable)) {
            callable = PrioritizedCallable.wrap(callable, Priority.NORMAL);
        }
        return new PrioritizedFutureTask((PrioritizedCallable)callable, this.insertionOrder.incrementAndGet());
    }

    static class PrioritizedFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PrioritizedFutureTask> {
        final Object task;
        final Priority priority;
        final long insertionOrder;

        public PrioritizedFutureTask(PrioritizedRunnable runnable, T value, long insertionOrder) {
            super(runnable, value);
            this.task = runnable;
            this.priority = runnable.priority();
            this.insertionOrder = insertionOrder;
        }

        public PrioritizedFutureTask(PrioritizedCallable<T> callable, long insertionOrder) {
            super(callable);
            this.task = callable;
            this.priority = callable.priority();
            this.insertionOrder = insertionOrder;
        }

        @Override
        public int compareTo(PrioritizedFutureTask pft) {
            int res = this.priority.compareTo(pft.priority);
            if (res != 0) {
                return res;
            }
            return this.insertionOrder < pft.insertionOrder ? -1 : 1;
        }
    }

    static class TieBreakingPrioritizedRunnable
    extends PrioritizedRunnable {
        final Runnable runnable;
        final long insertionOrder;

        TieBreakingPrioritizedRunnable(PrioritizedRunnable runnable, long insertionOrder) {
            this(runnable, runnable.priority(), insertionOrder);
        }

        TieBreakingPrioritizedRunnable(Runnable runnable, Priority priority, long insertionOrder) {
            super(priority);
            this.runnable = runnable;
            this.insertionOrder = insertionOrder;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public int compareTo(PrioritizedRunnable pr) {
            int res = super.compareTo(pr);
            if (res != 0 || !(pr instanceof TieBreakingPrioritizedRunnable)) {
                return res;
            }
            return this.insertionOrder < ((TieBreakingPrioritizedRunnable)pr).insertionOrder ? -1 : 1;
        }
    }

    public static class Pending {
        public final Object task;
        public final Priority priority;
        public final long insertionOrder;
        public final boolean executing;

        public Pending(Object task, Priority priority, long insertionOrder, boolean executing) {
            this.task = task;
            this.priority = priority;
            this.insertionOrder = insertionOrder;
            this.executing = executing;
        }
    }
}

